

<?php $__env->startSection('content'); ?>
<?php echo $__env->make('layouts.navbars.auth.topnav', ['title' => 'Mark Configuration'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div class="container-fluid py-4">
    <form>
        <div class="card p-1">
            <div class="card-header d-flex justify-content-between align-items-center">
                <div>Mark Configuration</div>
                <a class="btn btn-primary" href="<?php echo e(url('mark-upload-add')); ?>">Upload</a>
            </div>
            <div class="card-body">
                <!-- Filter Options -->
                <div class="row mb-3">
                    <div class="col-md-3">
                        <label for="exam_filter">Exam Name</label>
                        <select class="form-control" id="exam_filter">
                            <option value="">All Exams</option>
                            <?php $__empty_1 = true; $__currentLoopData = $exams; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <option value="<?php echo e($data->id); ?>"> <?php echo e($data->exam_name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <?php endif; ?>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label for="result_filter">Result Type</label>
                        <select class="form-control" id="result_filter">
                            <option value="">All Result Type</option>
                            <!-- Add dynamic course options here -->
                            <option value="R">Regular</option>
                            <option value="S">Supplementry</option>
                            <!-- Add other course options dynamically as needed -->
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label for="semester_filter">Semester</label>
                        <select class="form-control" id="semester_filter" name="semester">
                            <option value="">All Semesters</option>
                            <option value="1">Semester 1</option>
                            <option value="2">Semester 2</option>
                            <option value="3">Semester 3</option>
                            <option value="4">Semester 4</option>
                            <option value="5">Semester 5</option>
                            <option value="6">Semester 6</option>
                        </select>
                    </div>
                    <!-- <div class="col-md-3">
                        <label for="subject_filter">Subject</label>
                        <select class="form-control" id="subject_filter">
                            <option value="">All Subjects</option>
                            <option value="CS Paper-I">CS Paper-I</option>
                            <option value="CS Paper-II">CS Paper-II</option>
                          
                        </select>
                    </div> -->
                </div>

                <!-- Table -->
                <div class="table-responsive">
                    <table class="table table-bordered text-xs" id="marksTable">
                        <thead>
                        <tr>
                                <?php $__empty_1 = true; $__currentLoopData = $college_config; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <?php if(!empty($data->config_value)): ?>
                                        <th><?php echo e($data->config_value); ?></th>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    No data found.
                                <?php endif; ?>
                            </tr>
                        </thead>
                        <tbody>

                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </form>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>
    <script>
        $(document).ready(function () {
            var column_count = <?= count($college_config) ?>;
            var column_con = <?= $college_config ?>;
            var column_config = [];

            column_con.forEach(function (column) {
                if (column.config_value) {
                    column_config.push({
                        data: column.config_key, 
                        name: column.config_key 
                    });
                }
            })

            var table = $('#marksTable').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: '<?php echo e(route('marks.data')); ?>',
                    data: function (d) {
                        d.exam = $('#exam_filter').val();
                        d.result = $('#result_filter').val();
                        d.course = $('#course_filter').val();
                        d.semester = $('#semester_filter').val();
                        d.subject = $('#subject_filter').val();
                    }
                },
                columns: column_config,

                layout: {
                    topStart: {
                        buttons: [
                            {
                                extend: 'pageLength',
                                text: '<i class="fas fa-list"></i> Rows',
                                className: 'btn btn-info'
                            },
                            {
                                extend: 'excelHtml5',
                                text: '<i class="fas fa-file-excel"></i> Export',
                                className: 'btn btn-success',
                                title: 'Mark Configuration Data'
                            },
                            {
                                extend: 'colvis',
                                text: '<i class="fas fa fa-columns"></i> Columns',
                                className: 'btn btn-danger',
                                title: 'Mark Configuration Data'
                            }
                        ]
                    },
                },

            });

            $('#exam_filter,#result_filter,#course_filter, #semester_filter, #subject_filter').change(function () {
                table.draw();
            });
        });
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', ['class' => 'g-sidenav-show bg-gray-100'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\hp\Desktop\MS\mark-system\resources\views/mark-upload/index.blade.php ENDPATH**/ ?>