<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>Semester Result Report</title>
    <style>
        /* Global Styles */
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: #f4f7fa;
            /* Light background */
            color: #333;
            /* Dark text for readability */
            margin: 0;
            padding: 20px;
        }

        h1,
        h2 {
            text-align: center;
            color: #333;
        }

        /* Table Styling */
        table {
            width: 100%;
            table-layout: auto;
            border-collapse: collapse;

            background-color: #ffffff;
            border-radius: 5px;
            overflow: hidden;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
        }

        th,
        td {
            padding: 10px;
            text-align: left;
            border: 1px solid #ddd;
            font-size: 13px;
            word-wrap: break-word;
            /* word-break: break-word; */
            white-space: normal;
        }

        th {
            background-color: #f0f0f0;
            color: #555;
            font-weight: bold;
            text-transform: uppercase;
        }

        td {
            background-color: #fff;
        }

        tr:nth-child(even) td {
            background-color: #f9f9f9;
        }

        tr:hover td {
            background-color: #f0f9ff;
        }

        /* Header Section */
        .header {
            margin-bottom: 30px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
        }

        .header h1 {
            font-size: 24px;
            margin-bottom: 5px;
        }

        .header h2 {
            font-size: 16px;
            color: #777;
        }

        /* Student Info Table */
        .student-info table {
            width: 100%;
            padding: 6px;
            background-color: #fff;
            border-radius: 5px;
            margin-top: 10px;
            border-collapse: collapse;
            /* Merge the table borders */
        }

        .student-info td,
        .student-info th {
            padding: 6px;
            text-align: left;
            font-size: 14px;
        }

        /* Remove borders from the table */
        .student-info table,
        .student-info td,
        .student-info th {
            border: none;
        }

        .student-info td {
            width: 50%;
        }

        .student-info tr:nth-child(even) td {
            background-color: #fff;
        }

        .student-info td:first-child {
            width: 10%;
        }

        .student-info td:last-child {
            width: 88%;
        }

        .student-info td:nth-child(2) {
            width: 2%;
        }

        /* Footer Section */
        .footer {
            text-align: center;
            font-size: 12px;
            color: #888;
            margin-top: 30px;
        }

        .footer p {
            margin: 0;
        }

        /* Page Number */
        .page-number {
            text-align: right;
            font-size: 12px;
            color: #888;
            margin-top: 20px;
        }

        /* Additional Styling for the Report */
        .section-break {
            margin-top: 30px;
            border-bottom: 1px solid #ddd;
            margin-bottom: 30px;
        }

        .header-table {
            width: 100%;
            border: none;
            margin-bottom: 20px;
        }

        .header-table td {
            vertical-align: top;
            padding: 10px;
            text-align: center;
            border: none;
        }

        .college-logo {
            width: 100px;
            height: auto;
        }

        /* Styling for Total, Overall Result, SGPA */
        .summary-row {
            background-color: #f0f0f0;
            font-weight: bold;
            text-align: right;
        }

        .summary-row td {
            text-align: left;
        }

        .summary-data {
            font-weight: bold;
            color: #0056b3;
        }
    </style>
</head>

<body>

    <table class="header-table">
        <tr>
            <td><img class="college-logo" src="<?php echo e($college_logo); ?>" alt="College Logo"></td>
            <td>
                <h1><?php echo e($college->college_name); ?></h1>
                <p><?php echo e($college->address); ?></p>
                <p><?php echo e($college->email); ?> | <?php echo e($college->mobile); ?></p>
            </td>
            <td><img class="college-logo" src="" alt=""></td>
        </tr>
    </table>

    <div class="student-info">
        <table>
            <tr>
                <td><strong>Student Name</strong></td>
                <td>:</td>
                <td><?php echo e($mark_first->{$std_name_key}); ?></td>
            </tr>
            <tr>
                <td><strong>Register Number</strong></td>
                <td>:</td>
                <td><?php echo e($mark_first->{$reg_no_key}); ?></td>
            </tr>
            <tr>
                <td><strong>Course</strong></td>
                <td>:</td>
                <td><?php echo e($mark_first->{$course_key}); ?></td>
            </tr>
            <!-- <tr>
            <td><strong>Group</strong></td>
            <td>:</td>
            <td><?php echo e($mark_first->config_4); ?></td>
        </tr> -->
        </table>
    </div>


    <table>
        <thead>
            <tr>
                <th>S.No</th>
                <?php $__currentLoopData = $config_view; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <th><?php echo e($data->config_value); ?></th>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $marks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mark): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
            <td><?php echo e($loop->iteration); ?></td>
            <?php $__currentLoopData = $config_view; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $attribute_value = $mark->{$data->config_key} ?? null;
                ?>
                <td>
                    <?php if($attribute_value !== null): ?>
                        <?php echo e($attribute_value); ?>

                    <?php else: ?>
                        N/A
                    <?php endif; ?>
                </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php
                $overall_result = "Pass";

                // Loop through each student's marks
                foreach ($marks as $mark) {
                    // Loop through each attribute (or column) of the mark
                    foreach ($mark->getAttributes() as $attribute_name => $attribute_value) {
                        // Check if the attribute is the 'Result' column and if it contains 'Fail'
                        if ($attribute_name == $result_key && strtolower($attribute_value) == "fail") {
                            $overall_result = "Fail"; // If any result is Fail, overall result should be Fail
                            break 2; // Exit both loops if Fail is found
                        }
                    }
                }
            ?>
            <tr class="summary-row">
                <td colspan="<?php echo e(count($config_view) / 1.5); ?>">Total</td>
                <td colspan="<?php echo e(count($config_view)); ?>" class="summary-data"><?php echo e($total_marks); ?></td>
            </tr>
            <tr class="summary-row">
                <td colspan="<?php echo e(count($config_view) / 1.5); ?>">Overall Result</td>
                <td colspan="<?php echo e(count($config_view)); ?>" class="summary-data"><?php echo e($overall_result); ?></td>
            </tr>
            <!-- <tr class="summary-row">
                <td colspan="<?php echo e(count($config_view)/1.5); ?>">SGPA</td>
                <td  colspan="<?php echo e(count($config_view)); ?>" class="summary-data">8.5</td>
            </tr> -->
        </tbody>
    </table>

    <div class="section-break"></div>

    <div class="footer">
        <p>© 2024 <?php echo e($college->college_name); ?> | Contact Us: <?php echo e($college->email); ?></p>
    </div>

    <div class="page-number">Report Generated: <?php echo e(now()->format('F j, Y')); ?></div>

</body>

</html><?php /**PATH C:\Users\hp\Desktop\MS\mark-system\resources\views/mark-upload/result-pdf.blade.php ENDPATH**/ ?>