
<?php
use Illuminate\Support\Facades\Auth;
?>

<?php $__env->startSection('content'); ?>
<?php echo $__env->make('layouts.navbars.auth.topnav', ['title' => 'Mark Config Add'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<div class="container-fluid py-4">
    <div class="card p-1">
        <form action="<?php echo e(route('marks.import')); ?>" method="POST" enctype="multipart/form-data">
            <div class="card-header d-flex justify-content-between align-items-center">
                <div>Mark Upload</div>
                <div>
                    <button type="submit" class="btn btn-primary">Upload</button>
                    <a href="<?php echo e(url('mark-upload')); ?>" class="btn btn-secondary">Cancel</a>
                </div>
            </div>
            <div class="card-body">
                <!-- Form to handle file upload -->

                <?php echo csrf_field(); ?>
                <div class="row">
                    <div class="col-md-6 col-lg-4 mt-3">
                        <label for="exam_name">Exam Name</label>
                        <input type="text" class="form-control" id="exam_name" name="exam_name"
                            placeholder="Enter Exam Name">
                    </div>
                    <div class="col-md-6 col-lg-4 mt-3">
                        <label for="start_date">Start Date</label>
                        <input type="date" class="form-control" id="start_date" name="start_date"
                            placeholder="Enter Start Date">
                    </div>
                    <div class="col-md-6 col-lg-4 mt-3">
                        <label for="end_date">End Date</label>
                        <input type="date" class="form-control" id="end_date" name="end_date"
                            placeholder="Enter End Date">
                    </div>

                    <div class="row">
                        <!-- Status Dropdown -->
                        <div class="col-md-6 col-lg-4 mt-3">
                            <label for="status">Status</label>
                            <select class="form-select" id="status" name="status">
                                <option selected>Select status</option>
                                <option value="1">Active</option>
                                <option value="2">Inactive</option>
                            </select>
                        </div>
                        <div class="col-md-6 col-lg-4 mt-3">
                            <label for="result_type">Result Type</label>
                            <select class="form-select" id="result_type" name="result_type">
                                <option selected>Select type</option>
                                <option value="R">Regular</option>
                                <option value="S">Supplementary</option>
                            </select>
                        </div>

                        <!-- Mark File Upload -->
                        <div class="col-md-6 col-lg-8 mt-3">
                            <label for="mark_file">Mark File</label>
                            <div class="d-flex">
                                <input type="file" class="form-control me-2" id="mark_file" name="mark_file"
                                    style="height: 40px; width:380px">
                                <a href="<?php echo e(url('template/'.Auth::user()->college_id)); ?>" class="btn btn-primary">Download Template</a>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </form>
    </div>
</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', ['class' => 'g-sidenav-show bg-gray-100'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\hp\Desktop\MS\mark-system\resources\views/mark-upload/add.blade.php ENDPATH**/ ?>