<?php

use App\Http\Controllers\CollegeConfigController;
use App\Http\Controllers\ExamController;
use App\Http\Controllers\LoginController;
use App\Http\Controllers\MarkController;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;
use Maatwebsite\Excel\Facades\Excel;
use App\Exports\CollegeConfigExport;

Route::get('/', function () {
    return view('auth.login');
})->name('login');

Route::post('/login', [LoginController::class, 'login'])->name('login-check');

Route::middleware('auth')->group(function () {
    
    Route::get('/mark-config', function () {
        return view('mark-config.index');
    });

    Route::get('/mark-config-add', function () {
        return view('mark-config.add');
    })->name('college-config-add');
    
    Route::get('/mark-upload', [MarkController::class,'index'])->name('mark-upload');

    Route::get('/mark-upload-add', function () {
        return view('mark-upload.add');
    });

    Route::get('/std-mark', [MarkController::class,'studentIndex'])->name('std-mark');

    Route::get('/mark-report', function () {
        return view('mark-upload.std-mark-report');
    });

    Route::get('/college-get', [CollegeConfigController::class, 'getCollegeData'])->name('college.getdata');
    Route::post('/college/add', [CollegeConfigController::class, 'store'])->name('college.add');
    Route::post('/marks/import', [MarkController::class, 'import'])->name('marks.import');

    Route::get('/marks/data', [MarkController::class, 'getMarksData'])->name('marks.data');
    Route::get('/std/marks', [MarkController::class, 'getStdMark'])->name('std.marks');
    Route::get('/generate-report', [MarkController::class, 'generatePDF'])->name('generate-report');

    Route::get('/template/{college_id}', function ($college_id) {
        return Excel::download(new CollegeConfigExport($college_id), 'mark_template.xlsx');
    });

    Route::get('/examlist', [ExamController::class, 'index'])->name('examlist');
    Route::get('/exam/data', [ExamController::class, 'getExamsData'])->name('exam.data');
    Route::get('/get-exam/{id}', [ExamController::class, 'getExamById']);
    Route::get('/edit-exam', [ExamController::class, 'editExam'])->name('edit-exam');
    Route::delete('/exam/{id}', [ExamController::class, 'deleteExam'])->name('delete-exam');

    Route::post('logout', function () {
        Auth::logout(); 
        return redirect()->route('login'); 
    })->name('logout');
});

Route::get('/mark-report', function () {
    return view('mark-upload.std-mark-report');
});

Route::get('/results', [MarkController::class, 'resultIndex'])->name('results');

Route::get('/generate-report', [MarkController::class, 'generatePDF'])->name('generate-report');