@extends('layouts.app', ['class' => 'g-sidenav-show bg-gray-100'])

@section('content')
@include('layouts.navbars.auth.topnav', ['title' => 'Mark Configuration'])

<div class="container-fluid py-4">
    <form>
        <div class="card p-1">
            <div class="card-header d-flex justify-content-between align-items-center">
                <div>Mark Configuration</div>
                <a class="btn btn-primary" href="{{ url('mark-config-add') }}">New</a>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover text-sm" id="college_table">
                        <thead>
                            <tr>
                                <th>S.No</th>
                                <th>College Name</th>
                                <th>Config 1</th>
                                <th>Config 2</th>
                                <th>Config 3</th>
                                <th>Config 4</th>
                                <th>Config 5</th>
                                <th>Config 6</th>
                                <th>Config 7</th>
                                <th>Config 8</th>
                                <th>Config 9</th>
                                <th>Config 10</th>
                                <th>Config 11</th>
                                <th>Config 12</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td></td>
                            </tr>
                        </tbody>

                    </table>
                </div>
            </div>
        </div>
    </form>
</div>
@endsection
@push('scripts')
<script>
    $(document).ready(function () {
        var table = $('#college_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: "{{ route('college.getdata') }}",
                error: function (xhr, status, error) {
                    if (xhr.status === 500 && xhr.responseJSON.error) {
                        toastr.error(xhr.responseJSON.error);
                    } else {
                        toastr.error('An unexpected error occurred.');
                    }
                }
            },
            columns: [
                { data: 'DT_RowIndex', name: 'DT_RowIndex', orderable: false, searchable: false },
                { data: 'college_name', name: 'college_name' },
                { data: 'config_1', name: 'config_1' },
                { data: 'config_2', name: 'config_2' },
                { data: 'config_3', name: 'config_3' },
                { data: 'config_4', name: 'config_4' },
                { data: 'config_5', name: 'config_5' },
                { data: 'config_6', name: 'config_6' },
                { data: 'config_7', name: 'config_7' },
                { data: 'config_8', name: 'config_8' },
                { data: 'config_9', name: 'config_9' },
                { data: 'config_10', name: 'config_10' },
                { data: 'config_11', name: 'config_11' },
                { data: 'config_12', name: 'config_12' },
                { data: 'action', name: 'action', orderable: false, searchable: false }
            ]
        });

        $('#change').change(function () {
            table.draw();
        });
    });
</script>
@endpush
