@extends('layouts.app', ['class' => 'g-sidenav-show bg-gray-100'])

@section('content')
@include('layouts.navbars.auth.topnav', ['title' => 'Examlist'])

<div class="container-fluid py-4">
    <form>
        <div class="card p-1">
            <div class="card-header d-flex justify-content-between align-items-center">
                <div>Examlist</div>
            </div>
            <div class="card-body">
                <!-- Table -->
                <div class="table-responsive">
                    <table class="table table-bordered text-xs" id="examTable">
                        <thead>
                            <tr>
                                <th>S.no</th>
                                <th>Exam Name</th>
                                <th>Status</th>
                                <th>Result Type</th>
                                <th>Start Date</th>
                                <th>End Date</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <!-- Data will be loaded here by DataTables -->
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </form>
</div>


<div class="modal fade" id="editExamModal" tabindex="-1" aria-labelledby="editExamModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg"> <!-- Increased modal size -->
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editExamModalLabel">Edit Exam</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form action="{{route('edit-exam')}}">
                    @csrf
                    <input type="hidden" id="exam_id" name="exam_id"> <!-- Hidden field for exam id -->
                    <div class="row">
                        <!-- Left column -->
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="exam_name" class="form-label">Exam Name</label>
                                <input type="text" class="form-control" id="exam_name" name="exam_name">
                            </div>
                            <div class="mb-3">
                                <label for="end_date" class="form-label">End Date</label>
                                <input type="date" class="form-control" id="end_date" name="end_date">
                            </div>
                            <div class="mb-3">
                                <label for="status" class="form-label">Status</label>
                                <select class="form-select" id="status" name="status">
                                    <option value="1">Active</option>
                                    <option value="2">Inactive</option>
                                </select>
                            </div>
                        </div>

                        <!-- Right column -->
                        <div class="col-md-6">

                            <div class="mb-3">
                                <label for="start_date" class="form-label">Start Date</label>
                                <input type="date" class="form-control" id="start_date" name="start_date">
                            </div>
                            <div class="mb-3">
                                <label for="result_type" class="form-label">Result Type</label>
                                <select class="form-select" id="result_type" name="result_type">
                                    <option value="R">Regular</option>
                                    <option value="S">Supplementary</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <button type="submit" class="btn btn-primary">Update</button>
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                </form>
            </div>
        </div>
    </div>
</div>



<div class="modal fade" id="deleteConfirmationModal" tabindex="-1" aria-labelledby="deleteConfirmationModalLabel"
    aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="deleteConfirmationModalLabel">Confirm Deletion</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                Are you sure you want to delete this exam?
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-danger" id="confirmDeleteBtn">Delete</button>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
    <script>
        $(document).ready(function () {
            var table = $('#examTable').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: '{{ route('exam.data') }}',
                },
                columns: [
                    { data: 'DT_RowIndex', name: 'DT_RowIndex' },
                    { data: 'exam_name', name: 'exam_name' },
                    { data: 'status', name: 'status' },
                    { data: 'exam_type', name: 'exam_type' },
                    { data: 'start_date', name: 'start_date' },
                    { data: 'end_date', name: 'end_date' },
                    { data: 'action', name: 'action', orderable: false, searchable: false },
                ],
                layout: {
                    topStart: {
                        buttons: [
                            {
                                extend: 'pageLength',
                                text: '<i class="fas fa-list"></i> Rows',
                                className: 'btn btn-info'
                            },
                            {
                                extend: 'excelHtml5',
                                text: '<i class="fas fa-file-excel"></i> Export',
                                className: 'btn btn-success',
                                title: 'Examlist Data'
                            },
                            {
                                extend: 'colvis',
                                text: '<i class="fas fa fa-columns"></i> Columns',
                                className: 'btn btn-danger',
                                title: 'Examlist Data'
                            }
                        ]
                    },
                },
            });

            window.editExam = function (id) {

                $.ajax({
                    url: '/get-exam/' + id,
                    method: 'GET',
                    success: function (data) {
                        $('#exam_id').val(data.id);
                        $('#exam_name').val(data.exam_name);
                        $('#start_date').val(data.start_date);
                        $('#end_date').val(data.end_date);
                        $('#status').val(data.status);
                        $('#result_type').val(data.exam_type);

                        $('#editExamModal').modal('show');
                    },
                    error: function (error) {
                        console.error('Error fetching exam data:', error);
                    }
                });
            };

            window.deleteExam = function (id) {
                $('#confirmDeleteBtn').click(function () {
                    $.ajax({
                        url: '/exam/' + id,
                        method: 'DELETE',
                        data: {
                            _token: $('meta[name="csrf-token"]').attr('content')
                        },
                        success: function () {
                            table.ajax.reload();
                            $('#deleteConfirmationModal').modal('hide');
                        }
                    });
                });
                $('#deleteConfirmationModal').modal('show');
            };
        });
    </script>
@endpush