<?php

namespace App\Imports;

use App\Models\CollegeConfig;
use App\Models\Mark;
use App\Models\MarkConfig;
use Illuminate\Support\Facades\Auth;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;

class MarksImport implements ToModel, WithHeadingRow
{
    public $request;
    public $user;
    public $college_config,$mark;
    function __construct($request,$mark,$config_data)
    {
        $this->request = $request;
        $this->college_config = $config_data;
        $this->mark = $mark;
        $this->user = Auth::user();

    }
    /**
    * @param array $row
    *
    * @return \Illuminate\Database\Eloquent\Model|null
    */
    public function model(array $row)
    {
       $configData = [];

    
        foreach ($this->college_config as $config) {
            $configKey = $config->config_key;
            $configValue = $config->config_value;
            foreach ($row as $index => $columnName) {
                if ($index === strtolower(str_replace(' ', '_',$configValue))) {
                    $configData[$configKey] =  $row[$index];
                    break; 
                }
            }
        }
       
         return new MarkConfig(array_merge(['mark_id' => $this->mark->id], $configData));
    }
}
