<?php

namespace App\Http\Controllers;

use App\Models\MarkConfig;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\Mark;
use Yajra\DataTables\Facades\DataTables;

class ExamController extends Controller
{
    public $user;
    function __construct()
    {
        $this->user = Auth::user();
    }
    public function index()
    {
        return view('examlist.index');
    }

    public function getExamsData()
    {
        $exams = Mark::where('college_id', $this->user->college_id)->get();

        return DataTables::of($exams)
           ->addIndexColumn()
            ->addColumn('status', function ($row) {
                return $row->status == 1 ? 'Active' : 'Inactive';
            })
            ->addColumn('exam_type', function ($row) {
                return $row->exam_type == 'R' ? 'Regular' : ($row->exam_type == 'S' ? 'Supplementary' : 'Unknown');
            })
            ->addColumn('start_date', function ($row) {
                return Carbon::parse($row->start_date)->format('d/m/Y');
            })
            ->addColumn('end_date', function ($row) {
                return Carbon::parse($row->end_date)->format('d/m/Y');
            })
            ->addColumn('action', function ($row) {
                $editBtn = '<a href="javascript:void(0)" onclick="editExam(' . $row->id . ')" class="text-warning"><i class="fa fa-edit"></i></a>';
                $deleteBtn = '<a href="javascript:void(0)" onclick="deleteExam(' . $row->id . ')" class="text-danger"><i class="fa fa-trash"></i></a>';
                return $editBtn . ' ' . $deleteBtn;
            })
            ->rawColumns(['action'])
            ->make(true);
    }

    public function getExamById($id){

        $exam = Mark::findOrFail($id);
        return response()->json($exam);
    }

    public function editExam(Request $request){
        $exam = Mark::findOrFail($request->exam_id);

        $exam->exam_name = $request->exam_name;
        $exam->status = $request->status;
        $exam->start_date = $request->start_date;
        $exam->end_date = $request->end_date;
        $exam->exam_type = $request->result_type;

        $exam->save();

        return redirect()->to('examlist')->with('success', "Updated Successfully!");
    }

    public function deleteExam($id)
    {
        try {
            Mark::findOrFail($id)->delete();
           
            MarkConfig::where('mark_id', $id)->delete();
    
            return response()->json(['message' => 'Exam and related Mark records deleted successfully.'], 200);
        } catch (\Exception $e) {
            return response()->json(['error' => 'Failed to delete the exam'], 500);
        }
    }
    
}
