@extends('layouts.layoutapp')

@section('content')
  <div class="row">
        <div class="col-12">
            <div class="card me-2">
                    <!-- Card Header -->
                    <div class="card-header pb-0">
                        <div class="d-flex flex-row justify-content-between">
                            <div>
                                <h5 class="mb-0">Invoice Payments</h5>
                            </div>
                            <a href="{{ route('invoice-payment-add') }}" class="btn bg-gradient-primary btn-sm mb-0"
                                type="button">
                                +&nbsp; Add Payments
                            </a>
                        </div>
                    </div>

                    <!-- Card Body -->
                    <div class="card-body px-0 pt-0 pb-2">

                        <div class="table-responsive p-0">
                            <table class="table align-items-center mb-0" id="myTable">
                                <thead>
                                    <tr>
                                        <th
                                            class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                            Invoices
                                        </th>
                                        <th
                                            class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                            Client Name
                                        </th>
                                        <th
                                            class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                            Invoice Date
                                        </th>
                                        <th
                                            class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                            Status
                                        </th>
                                        <th
                                            class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                            Actions
                                        </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($payments_data as $data)
                                                                    <tr>
                                                                        <td class="ps-4">
                                                                            <p class="text-xs font-weight-bold mb-0">{{ $data->invoice_id ?? '' }}</p>
                                                                        </td>
                                                                        <td class="ps-4">
                                                                            <p class="text-xs font-weight-bold mb-0">
                                                                                {{ $data->client->user->name . ' ' . $data->client->user->last_name ?? '' }}</p>
                                                                        </td>
                                                                        <td class="ps-4">
                                                                            <p class="text-xs font-weight-bold mb-0">{{ $data->invoice_date ?\Carbon\Carbon::parse($data->invoice_date)->format('d-m-Y') : '' }}</p>
                                                                        </td>
                                                                        <td class="ps-4">
                                                                            @php
                                                                                $statusName = optional($status->firstWhere('id', $data->status))->name;
                                                                                $badgeClass = 'bg-secondary';

                                                                                if ($statusName == 'Paid') {
                                                                                    $badgeClass = 'bg-success';
                                                                                } elseif ($statusName == 'Partially Paid') {
                                                                                    $badgeClass = 'bg-warning';
                                                                                } elseif ($statusName == 'Unpaid') {
                                                                                    $badgeClass = 'bg-danger';
                                                                                }
                                                                            @endphp

                                                                            <span class="badge {{ $badgeClass }}">{{ $statusName ?? 'Unknown' }}</span>
                                                                        </td>

                                                                        <td class="text-center">
                                                                            <a href="{{ route('invoice-payment-edit', $data->id) }}">
                                                                                <i class="fa-solid fa-pen-to-square text-secondary"></i>
                                                                            </a>
                                                                            <span class="ms-2">
                                                                                <form action="{{ route('invoice-payment-delete', $data->id) }}"
                                                                                    method="POST" class="d-inline" id="delete-form-{{$data->id}}">
                                                                                    @csrf
                                                                                    @method('DELETE')
                                                                                    <i class="cursor-pointer fas fa-trash text-secondary"
                                                                                        onclick="confirmDelete({{$data->id}})"></i>
                                                                                </form>
                                                                            </span>
                                                                        </td>
                                                                    </tr>                                   
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
@endsection

@push('scripts')
    <script>
        function confirmDelete(id) {
            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Yes, delete it!',
                cancelButtonText: 'Cancel'
            }).then((result) => {
                if (result.isConfirmed) {
                    document.getElementById('delete-form-' + id).submit();
                }
            });
        }
    </script>
@endpush