<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Barryvdh\DomPDF\Facade as PDF;

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class QuoteCreated extends Mailable
{
    use Queueable, SerializesModels;

   
    protected $pdfData;
    protected $order;
    protected $settings;

    public function __construct($pdfData, $order, $settings)
    {
        $this->pdfData = $pdfData;
        $this->order = $order;
        $this->settings = $settings;
    }

    public function build()
    {
        return $this->subject('New Order Created - #' . $this->order->quote_id)
            ->view('mail.quote-created', [
                'order' => $this->order,
                'settings' => $this->settings,
            ])
            ->attachData($this->pdfData, 'order_' . $this->order->quote_id . '.pdf', [
                'mime' => 'application/pdf',
            ]);
    }
}
