

<?php $__env->startSection('content'); ?>
    <div class="main-content">
        <div class="row">
            <div class="col-12">
                <div class="card mb-4 mx-4">
                    <div class="card-header pb-0">
                        <div class="d-flex flex-row justify-content-between">
                            <div>
                                <h5 class="mb-0">Add Payment</h5>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <form action="<?php echo e(route('product-payment-store')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <div class="row">
                                <div class="col-lg-4 mb-4">
                                    <label for="product_dtl_id" class="form-label">Product:</label>
                                    <select class="form-select select2" id="product_dtl_id" name="product_dtl_id" required>
                                        <option value="">Select Product</option>
                                        <?php $__currentLoopData = $product_dtls; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($data->product_details_sid); ?>"><?php echo e($data->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <?php $__errorArgs = ['product_dtl_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="col-lg-4 mb-4">
                                    <label for="total_amount" class="form-label">Total Amount:</label>
                                    <input type="text" id="total_amount" class="form-control" name="total_amount" readonly>
                                    <?php $__errorArgs = ['total_amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="col-lg-4 mb-4">
                                    <label for="due_amount" class="form-label">Due Amount:</label>
                                    <input type="text" id="due_amount" class="form-control" name="due_amount" readonly>
                                    <?php $__errorArgs = ['due_amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="col-lg-4 mb-4">
                                    <label for="payment_date" class="form-label">Payment Date</label>
                                    <input type="date" id="payment_date" class="form-control" name="payment_date"
                                        value="<?php echo e(old('payment_date', now()->toDateString())); ?>" required>
                                    <?php $__errorArgs = ['payment_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="col-lg-4 mb-4">
                                    <label for="amount" class="form-label">Amount</label>
                                    <input type="text" id="amount" class="form-control" name="amount"
                                        value="<?php echo e(old('amount')); ?>" required>
                                    <?php $__errorArgs = ['amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="col-lg-4 mb-4">
                                    <label for="payment_type" class="form-label">Payment Method</label>
                                    <select name="payment_type" class="form-select" required>
                                        <option value="">Select Payment Method</option>
                                        <option value="cash" <?php echo e(old('payment_type') == 'cash' ? 'selected' : ''); ?>>Cash
                                        </option>
                                        <option value="upi" <?php echo e(old('payment_type') == 'upi' ? 'selected' : ''); ?>>Upi</option>
                                        <option value="online" <?php echo e(old('payment_type') == 'online' ? 'selected' : ''); ?>>Online
                                        </option>
                                    </select>
                                    <?php $__errorArgs = ['payment_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            <div class="d-flex justify-content-end">
                                <button type="submit" class="btn btn-primary">Save Payment</button>
                                <a href="<?php echo e(route('product-payment-index')); ?>" class="btn btn-secondary ms-2">Cancel</a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script>
        $(document).ready(function () {
            $('.select2').select2({
                placeholder: "Search Product",
                allowClear: true
            });

            $('#product_dtl_id').change(function () {
                const productId = $(this).val();
                if (productId) {
                    $.get(`/product-payments/get-product-details/${productId}`, function (data) {
                        $('#total_amount').val(data.totalAmount);
                        $('#due_amount').val(data.dueAmount);
                    }).fail(function () {
                        alert('Failed to fetch product details');
                    });
                } else {
                    $('#total_amount').val('');
                    $('#due_amount').val('');
                }
            });
        });
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.layoutapp', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /opt/lampp/htdocs/lara_commonbilling/resources/views/product-payments/add.blade.php ENDPATH**/ ?>