

<?php $__env->startSection('content'); ?>
<div class="main-content">
    <div class="row">
        <div class="col-12">
            <div class="card mb-4 mx-4">
                <div class="card-header pb-0">
                    <div class="d-flex flex-row justify-content-between">
                        <div>
                            <h5 class="mb-0">Edit Product</h5>
                        </div>                      
                    </div>
                </div>
                
                <div class="card-body">
                    <form action="<?php echo e(route('product-update')); ?>" method="POST" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                    <input type="hidden" name="product_id" value="<?php echo e($product->id); ?>">                        
                        <div class="row">
                            <div class="col-lg-6">
                                <div class="row">
                                    <div class="col-lg-6 mb-3">
                                        <label for="name" class="form-label">Name:</label>
                                        <input type="text" id="name" name="name" class="form-control" 
                                               value="<?php echo e(old('name', $product->name)); ?>" placeholder="Enter product name" required>
                                        <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="col-lg-6 mb-3">
                                        <label for="productCode" class="form-label">Product Code:</label>
                                        <input type="text" id="productCode" name="productCode" class="form-control" 
                                               value="<?php echo e(old('productCode', $product->code)); ?>" placeholder="Enter product code" required>
                                        <?php $__errorArgs = ['productCode'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>                                   
                                    
                                    <div class="col-lg-6 mb-3">
                                        <label for="unit_price" class="form-label">Selling Price / Unit:</label>
                                        <input type="number" id="unit_price" name="unit_price" class="form-control" 
                                               value="<?php echo e(old('unit_price', $product->unit_price)); ?>" placeholder="0.00" min="0" step="0.01" required>
                                        <?php $__errorArgs = ['unit_price'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="col-lg-6 mb-3">
                                        <label for="margin_price" class="form-label">Margin Price / Unit:</label>
                                        <input type="number" id="margin_price" name="margin_price" class="form-control" 
                                               value="<?php echo e(old('margin_price', $product->margin_price)); ?>" placeholder="0.00" min="0" step="0.01" required>
                                        <?php $__errorArgs = ['margin_price'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="col-lg-6 mb-3">
                                        <label for="category_id" class="form-label">Category:</label>
                                        <select name="category_id" class="form-select" required>
                                            <option value="" selected disabled>Select Category</option>
                                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($category->id); ?>" <?php echo e((old('category_id', $product->category_id) == $category->id) ? 'selected' : ''); ?>><?php echo e($category->name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <?php $__errorArgs = ['category_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="col-lg-6 mb-3">
                                        <label for="supplier_id" class="form-label">Supplier:</label>
                                        <select name="supplier_id" class="form-select" required>
                                            <option value="" selected disabled>Select Supplier</option>
                                            <?php $__currentLoopData = $suppliers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $supplier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($supplier->id); ?>" <?php echo e((old('supplier_id', $product->supplier_id) == $supplier->id) ? 'selected' : ''); ?>><?php echo e($supplier->supplier_name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <?php $__errorArgs = ['supplier_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    
                                    <div class="col-lg-12 mb-3">
                                        <label for="description" class="form-label">Description:</label>
                                        <textarea id="description" name="description" class="form-control" rows="2"
                                                  placeholder="Enter product description (optional)"><?php echo e(old('description', $product->description)); ?></textarea>
                                        <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="col-lg-6">
                                <div class="row">
                                    <div class="col-lg-6 mb-3">
                                        <label for="hsnCode" class="form-label">HSN Code:</label>
                                        <input type="text" id="hsnCode" name="hsnCode" class="form-control" 
                                               value="<?php echo e(old('hsnCode', $product->hsn_code)); ?>" placeholder="Enter HSN code" >
                                        <?php $__errorArgs = ['hsnCode'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="col-lg-6 mb-3">
                                        <label for="qty" class="form-label">Quantity:</label>
                                        <input type="number" id="qty" name="qty" class="form-control" 
                                               value="<?php echo e(old('qty', $product->qty)); ?>" placeholder="0" min="0" step="1" required >
                                        <?php $__errorArgs = ['qty'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="col-12 mb-3">
                                        <label for="product_image" class="form-label">Products Image:</label>
                                        <div class="d-flex align-items-center">
                                            <div class="avatar-upload me-5">
                                                <div class="avatar-preview">
                                                    <img id="imagePreview" src="<?php echo e($product->products_image ? getFileUrl($product->products_image) : asset('assets/img/logos/Product.png')); ?>" 
                                                        alt="Product Image" class="img-fluid" 
                                                        style="width: 150px; height: 150px; object-fit: cover;">
                                                </div>
                                            </div>
                                            <div class="avatar-edit">
                                                <input type="file" id="product_image" name="product_image" class="form-control file-upload-input" 
                                                    accept="image/*" onchange="previewImage(this)">
                                                <small class="text-muted">Upload new image (max 2MB)</small>
                                            </div>
                                        </div>
                                        <?php $__errorArgs = ['product_image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    
                                    
                                </div>
                            </div>
                        </div>                                            
                        
                        <div class="modal-footer">
                            <button type="submit" class="btn btn-primary">Update Product</button>
                            <a href="<?php echo e(route('product-index')); ?>" class="btn btn-secondary">Cancel</a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    function previewImage(input) {
        if (input.files && input.files[0]) {
            const reader = new FileReader();
            reader.onload = function(e) {
                document.getElementById('imagePreview').src = e.target.result;
            }
            reader.readAsDataURL(input.files[0]);
        }
    }    
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.layoutapp', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /opt/lampp/htdocs/lara_commonbilling/resources/views/products/edit.blade.php ENDPATH**/ ?>