<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/style.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/bootstrap.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/soft-ui-dashboard.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/soft-ui-dashboard.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/soft-ui-dashboard.css.map')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/nucleo-svg.css')); ?>">
    <title>Invoice</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
        }

        .header {
            width: 100%;
            margin-bottom: 0px;
            border-top: 1px solid #000;
            border-left: 1px solid #000;
            border-right: 1px solid #000;
        }

        .company-details {
            text-align: center;
        }

        .address {
            text-align: center;
            font-size: 18px;
            font-weight: bold;
        }

        .mail {
            text-align: center;
            font-size: 18px;
            font-weight: bold;
        }

        .invoice-details {
            width: 100%;
            margin-bottom: 0px;
            margin-top: 0px;
        }

        .info-table {
            width: 100%;
            border-top: 1px solid #000;
            border-left: 1px solid #000;
            border-right: 1px solid #000;
            border-collapse: collapse;
            /* table-layout: fixed; */
        }

        .info-table td {
            width: 50%;
            padding: 8px;
            vertical-align: top;
            border-right: 1px solid #000;
        }

        .client-details {
            text-align: left;
        }

        .invoice-info {
            text-align: left;
        }

        .product-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 0px;
        }

        .product-table th,
        .product-table td {
            border-left: 1px solid #000;
            border-right: 1px solid #000;
            padding: 3px;
            text-align: left;
        }

        .product-table tbody tr:last-child td {
            border-bottom: 1px solid #000;
        }

        .product-table th {
            background-color: #f2f2f2;
            border-top: 1px solid #000;
            border-bottom: 1px solid #000;
        }

        .footer {
            border-bottom: 1px solid #000;
            border-left: 1px solid #000;
            border-right: 1px solid #000;
            text-align: right;
            padding-right: 10px;
            width: 10s0%;
        }

        .col-id {
            width: 80px;
        }

        .col-description {
            width: 40%;
        }

        .col-code {
            width: 80px;
        }

        .col-qty {
            width: 80px;
        }

        .col-rate {
            width: 80px;
        }

        .col-gst {
            width: 80px;
        }

        .col-total {
            width: 90px;
        }

        .page-break {
            page-break-before: always;
        }

        .invoice-btn-section .row {
            display: flex;
            flex-wrap: nowrap;
            align-items: center;
        }

        .invoice-btn-section .btn {
            white-space: nowrap;
            margin: 0 5px;
        }

        .invoice-btn-section .form-select {
            min-width: 200px;
        }

        @media (max-width: 768px) {
            .invoice-btn-section .row {
                flex-wrap: wrap;
            }

            .invoice-btn-section .col-md-auto,
            .invoice-btn-section .col-md-3 {
                width: 100%;
                margin-bottom: 10px;
            }
        }
    </style>
</head>

<body>
    <div class="invoice-1 invoice-content">
        <div class="container">
            <div id="invoice_wrapper">
                <div class="header">
                    <div class="company-details">
                        <h3><?php echo e($addedInvoice->branch->company->name); ?></h3>
                    </div>
                    <div class="address">
                        <?php echo e($addedInvoice->branch->company->address); ?>,
                    </div>
                    <div class="mail">
                        Mail -<?php echo e($addedInvoice->branch->company->email); ?>


                    </div>
                </div>
                <div class="invoice-details">
                    <table class="info-table">
                        <tr>
                            <td class="client-details text-start">
                                <strong>GST No -</strong>
                                <?php echo e($addedInvoice->branch->gst_no ?? ''); ?><br>
                            </td>
                            <td class="invoice-info">
                                <strong>Contact No:</strong> <?php echo e($addedInvoice->branch->company->phone ?? ''); ?><br>
                            </td>
                        </tr>
                    </table>
                </div>
                <div class="invoice-details">
                    <table class="info-table">
                        <tr>
                            <td class="client-details text-start">
                                <strong>To:</strong>
                                <?php echo e($addedInvoice->client->user->name ?? ''); ?><br>
                                <strong>Address:</strong>
                                <?php echo e($addedInvoice->client->user->location ?? ''); ?>

                            </td>
                            <td class="invoice-info">
                                <strong>
                                    Payment Terms: </strong>
                                <?php if($addedInvoice->payments->isNotEmpty()): ?>
                                    <?php $__currentLoopData = $addedInvoice->payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($payment->mode): ?>
                                            <?php echo e($payment->mode->name); ?>

                                        <?php else: ?>
                                            N/A<br>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php else: ?>
                                    N/A
                                <?php endif; ?> <br>
                                <strong>Bill No:</strong>
                                <?php echo e($addedInvoice->invoice_id ?? ''); ?>

                                <br>
                                <strong>Date:</strong>
                                <?php echo e($addedInvoice->invoice_date ? \Carbon\Carbon::parse($addedInvoice->invoice_date)->format('d-m-Y') : ''); ?>

                            </td>
                        </tr>
                    </table>
                </div>
                <table class="product-table">
                    <thead>
                        <tr>
                            <th class="col-id">S.No</th>
                            <th class="col-description">Description</th>
                            <th class="col-code">HSN Code</th>
                            <th class="col-qty">Qty</th>
                            <th class="col-rate">Rate</th>
                            <th class="col-gst">GST(%)</th>
                            <th class="col-total">Total</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                            $subtotal = 0;
                            $pageSubtotal = 0;
                            $pageCount = 0;               
                        ?>
                        <?php $__currentLoopData = $addedInvoice->invoiceItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $total = $product->quantity * $product->price;
                                $gstAmount = ($product->total * $product->invoiceItemTaxes->sum('tax')) / 100;
                                $totalWithGst = $total + $gstAmount;
                                $subtotal += $totalWithGst;
                                $pageSubtotal += $totalWithGst;                                                                
                            ?>
                            <tr>
                                <td class="col-id"><?php echo e($index + 1); ?></td>
                                <td class="col-description"><?php echo e($product->product_name ?? ''); ?></td>
                                <td class="col-code">
                                    <?php echo e($product->products->code); ?>

                                </td>
                                <td class="col-qty">
                                    <?php echo e($product->quantity . '(' . ($product->products->category->unitOfMass->name ?? '') . ')' ?? ''); ?>

                                </td>
                                <td class="col-rate">₹ <?php echo e(number_format($product->price ?? '', 2)); ?></td>
                                <td class="col-gst">
                                    <?php echo e(number_format($product->invoiceItemTaxes->sum('tax') ?: 0, 2)); ?>

                                </td>
                                <td class="col-total"><?php
                                    $gstAmount = ($product->total * $product->invoiceItemTaxes->sum('tax')) / 100;
                                    $total = $product->total + $gstAmount;
                                ?>
                                    ₹ <?php echo e(number_format($total, 2)); ?>

                                </td>
                            </tr>

                            <?php if(($index + 1) % 18 == 0): ?>
                                    </tbody>
                                </table>
                                <div class="footer">
                                    <table class="footer-table" style="width: 100%; border-collapse: collapse;">
                                        <tr class="text-start">
                                            <td style="text-align: left;"><strong>Subtotal:</strong> </td>
                                            <td style="text-align: right;">₹ <?php echo e(number_format($pageSubtotal, 2)); ?></td>
                                        </tr>
                                        <tr class="text-start">
                                            <td style="text-align: left;"><strong>Previous Page Subtotal:</strong></td>
                                            <td style="text-align: right;">₹
                                                <?php echo e(number_format($subtotal - $pageSubtotal, 2)); ?>

                                            </td>
                                        </tr>
                                        <tr class="text-start">
                                            <td style="text-align: left;"><strong>Total:</strong></td>
                                            <td style="text-align: right;">₹ <?php echo e(number_format($subtotal, 2)); ?></td>
                                        </tr>
                                    </table>
                                </div>
                                <p style="text-align: right; margin-bottom: 30px;">...Continue</p>
                                <div class="page-break"></div>
                                <div class="header">
                                    <div class="company-details">
                                        <h3><?php echo e($addedInvoice->branch->company->name); ?></h3>
                                    </div>
                                    <div class="address">
                                        <?php echo e($addedInvoice->branch->company->address); ?>,
                                    </div>
                                    <div class="mail">
                                        Mail -<?php echo e($addedInvoice->branch->company->email); ?>

                                    </div>
                                </div>
                                <div class="invoice-details">
                                    <table class="info-table">
                                        <tr>
                                            <td class="client-details text-start">
                                                <strong>GST No -</strong>
                                                <?php echo e($addedInvoice->branch->gst_no ?? ''); ?><br>
                                            </td>
                                            <td class="invoice-info">
                                                <strong>Contact No:</strong> <?php echo e($addedInvoice->branch->company->phone ?? ''); ?><br>
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                                <div class="invoice-details">
                                    <table class="info-table">
                                        <tr>
                                            <td class="client-details text-start">
                                                <strong>To:</strong>
                                                <?php echo e($addedInvoice->client->user->name ?? ''); ?><br>
                                                <strong>Address:</strong>
                                                <?php echo e($addedInvoice->client->user->location ?? ''); ?>

                                            </td>
                                            <td class="invoice-info">
                                                <strong>Payment Terms:</strong>
                                                <?php echo e($addedInvoice->due_date ? \Carbon\Carbon::parse($addedInvoice->due_date)->format('d-m-Y') : ''); ?><br>
                                                <strong>Bill No:</strong>
                                                <?php echo e($addedInvoice->invoice_id ?? ''); ?>

                                                <br>
                                                <strong>Date:</strong>
                                                <?php echo e($addedInvoice->invoice_date ? \Carbon\Carbon::parse($addedInvoice->invoice_date)->format('d-m-Y') : ''); ?>

                                            </td>
                                        </tr>
                                    </table>
                                </div>
                                <table class="product-table">
                                    <thead>
                                        <tr>
                                            <th class="col-id">S.No</th>
                                            <th class="col-description">Description</th>
                                            <th class="col-code">HSN Code</th>
                                            <th class="col-qty">Qty</th>
                                            <th class="col-rate">Rate</th>
                                            <th class="col-gst">GST(%)</th>
                                            <th class="col-total">Total</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                            $pageSubtotal = 0;
                                            $pageCount++;
                                        ?>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> </tbody>
                </table>
                <div class="footer">
                    <table class="footer-table" style="width: 100%; border-collapse: collapse;">
                        <tr>
                            <td style="text-align:left"> <strong>Subtotal:</strong></td>
                            <td style="text-align:right;">₹ <?php echo e(number_format($pageSubtotal, 2)); ?></td>
                        </tr>
                        <tr>
                            <td style="text-align:left"> <strong>Previous Page Subtotal:</strong></td>
                            <td style="text-align:right;">₹
                                <?php echo e(number_format($subtotal - $pageSubtotal, 2)); ?>

                            </td>
                        </tr>
                        <tr>
                            <td style="text-align:left"> <strong>Total:</strong></td>
                            <td style="text-align:right;">₹ <?php echo e(number_format($subtotal, 2)); ?></td>
                        </tr>
                        <tr>
                            <?php if ($addedInvoice->discount_type == 1) {
                            $discount = $addedInvoice->discount;
                            } elseif ($addedInvoice->discount_type == 2) {
                            $discountAmount = ($subtotal * $addedInvoice->discount)
                            / 100;
                            $discount = $discountAmount;
                            } else {
                            $discount = 0;
                            }
                            ?>
                            <td style="text-align:left"> <strong>Discount:</strong></td>
                            <td style="text-align:right;">₹ <?php echo e(number_format($discount, 2)); ?></td>
                        </tr>
                        <tr>
                            <td style="text-align:left"> <strong>GrandTotal:</strong></td>
                            <td style="text-align:right;">₹ <?php echo e(number_format(floor($subtotal - $discount), 2)); ?></td>
                        </tr>
                        <tr>
                            <td style="text-align:left"><strong>Total Purchased Product Qty </strong></td>
                            <td class="text-align:right;">
                                <?php
                                    $sumQty = 0;
                                    foreach ($addedInvoice->invoiceItems as $item) {
                                        $sumQty += $item->quantity;
                                    }                      
                                ?>
                                <?php echo e($sumQty ?? 0); ?>

                            </td>
                        </tr>
                        <tr>
                            <td style="text-align:left" colspan="2"> <strong>Amount In words:</strong>
                                <?php echo e(amountToWords($subtotal - $discount)); ?></td>

                        </tr>
                        <?php if(isset($settings->declaration)): ?>
                            <tr>
                                <td style="text-align:left" colspan="2"> <strong>Terms & Conditions:</strong>
                                    <?php echo e(isset($settings->declaration) ? $settings->declaration : ''); ?>

                                </td>
                            </tr>
                        <?php endif; ?>
                    </table>
                </div>
                <div class="row">
                    <div class="col-lg-12">
                        <div class="invoice-inner clearfix">
                            <div class="invoice-btn-section clearfix d-print-none">
                                <div class="row align-items-center gx-2 gy-2 mt-0">
                                    <div class="col-md-3">
                                        <select name="paper_size" id="paper_size" class="form-select">
                                            <option value="">Select Standard paper size</option>
                                            <?php $__currentLoopData = $paper; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($item->id); ?>"><?php echo e($item->name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>

                                    <div class="col-md-auto">
                                        <a href="#" class="btn" id="print_btn">
                                            <i class="fa fa-print"></i> Print Invoice
                                        </a>
                                    </div>

                                    <div class="col-md-auto">
                                        <a id="invoice_download_btn" class="btn">
                                            <i class="fa fa-download"></i> Download Invoice
                                        </a>
                                    </div>

                                    <?php if($settings->whatsapp_config == 'A'): ?>
                                        <div class="col-md-auto">
                                            <a href="#" id="send_invoice" class="btn">
                                                <i class="fa-brands fa-whatsapp"></i> Send Invoice
                                            </a>
                                        </div>
                                    <?php endif; ?>

                                    <div class="col-md-auto">
                                        <a href='<?php echo e(route('invoice-index')); ?>' id="cancel-btn" class="btn">
                                            <i class="fa fa-arrow-left"></i> Back
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>

        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script src="<?php echo e(asset('assets/js/core/popper.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/core/bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/plugins/smooth-scrollbar.min.js')); ?>"></script>

    <script src="<?php echo e(asset('assets/js/jspdf.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/html2canvas.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/app.js')); ?>"></script>
    <script>
        $(function () {

            'use strict';

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $(document).on('click', '#invoice_download_btn', function () {
                var formData = new FormData();
                formData.append("invoice_id", "<?php echo e($addedInvoice->id); ?>");
                formData.append("type", "download");

                $.ajax({
                    url: '<?php echo e(route('show-pdf')); ?>',
                    method: 'POST',
                    data: formData,
                    contentType: false,
                    processData: false,
                    xhrFields: {
                        responseType: 'blob'
                    },
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    success: function (response) {
                        var link = document.createElement('a');
                        var blob = response;
                        var url = window.URL.createObjectURL(blob);
                        link.href = url;
                        link.download = "<?php echo e($addedInvoice->invoice_id); ?>.pdf";
                        link.click();
                        window.URL.revokeObjectURL(url);
                    },
                    error: function (error) {
                        console.log("Error saving the file:", error);
                    }
                });
            });
            $(document).on('click', '#print_btn', function () {
                var formData = new FormData();
                formData.append("invoice_id", "<?php echo e($addedInvoice->id); ?>");
                formData.append("type", "print");

                $.ajax({
                    url: '<?php echo e(route('show-pdf')); ?>',
                    method: 'POST',
                    data: formData,
                    contentType: false,
                    processData: false,
                    xhrFields: {
                        responseType: 'blob'
                    },
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') // Include CSRF token in the request header
                    },
                    success: function (response) {
                        var blob = response;
                        var url = window.URL.createObjectURL(blob);
                        var printWindow = window.open(url, '_blank');
                        printWindow.onload = function () {
                            printWindow.print();
                        };
                    },
                    error: function (error) {
                        console.log("Error saving the file:", error);
                    }
                });
            });
        });
    </script>
    <script>
        $(function () {
            $(document).on('click', '#send_invoice', function () {
                $(".invoice-btn-section").hide();

                var content = $("#invoice_wrapper")[0];
                var contentWidth = content.offsetWidth;
                var contentHeight = content.offsetHeight;
                var pdfWidth = 80;
                var pdfHeight = (contentHeight * pdfWidth) / contentWidth;

                html2canvas(content, {
                    allowTaint: true,
                    scale: 2,
                    useCORS: true
                }).then(function (canvas) {
                    var imgData = canvas.toDataURL("image/jpeg", 1.0);
                    var pdf = new jsPDF('p', 'mm', [pdfWidth, pdfHeight]);
                    pdf.addImage(imgData, 'JPEG', 0, 0, pdfWidth, pdfHeight);

                    var pdfBlob = pdf.output('blob');
                    var formData = new FormData();
                    formData.append("invoice_pdf", pdfBlob, "invoice_<?php echo e($addedInvoice->invoice_id); ?>.pdf");
                    formData.append("_token", "<?php echo e(csrf_token()); ?>");
                    formData.append("invoice_id", "<?php echo e($addedInvoice->invoice_id); ?>");
                    formData.append("invoice_amnt", "<?php echo e($addedInvoice->final_amount); ?>");
                    formData.append("phone_number", "<?php echo e($addedInvoice->client->user->phone ?? ''); ?>");
                    // Send the PDF to the backend
                    $.ajax({
                        url: "<?php echo e(route('send.invoice')); ?>",
                        type: "POST",
                        data: formData,
                        processData: false,
                        contentType: false,
                        success: function (response) {
                            if (response.success) {
                                Swal.fire({
                                    title: "Success!",
                                    text: "Message sent successfully!",
                                    icon: "success",
                                    confirmButtonText: "OK"
                                })
                            } else {
                                Swal.fire({
                                    title: "Error!",
                                    text: "Error sending invoice!",
                                    icon: "error",
                                    confirmButtonText: "OK"
                                });
                            }
                            $(".invoice-btn-section").show();
                        },
                        error: function () {
                            Swal.fire({
                                title: "Error!",
                                text: "Something went wrong while processing the request.",
                                icon: "error",
                                confirmButtonText: "OK"
                            });
                            $(".invoice-btn-section").show();
                        }
                    });
                });
            });
        });       
    </script>
    <script>
        $(function () {
            $(document).on('change', '#paper_size', function () {
                const paperId = $('#paper_size').val();
                const invoiceId = "<?php echo e($addedInvoice->id); ?>";

                window.location.href = "<?php echo e(route('pdf', ['id' => 'INVOICE_ID_PLACEHOLDER'])); ?>".replace('INVOICE_ID_PLACEHOLDER', invoiceId) + "?paperId=" + paperId;
            });
        });
    </script>
</body>

</html><?php /**PATH /opt/lampp/htdocs/lara_commonbilling/resources/views/pdf/billGenerate.blade.php ENDPATH**/ ?>