<?php

use App\Http\Controllers\Api\MobAuthController;
use App\Http\Controllers\Api\MobCategoryController;
use App\Http\Controllers\Api\MobExpenseController;
use App\Http\Controllers\Api\MobProductController;
use App\Http\Controllers\Api\MobQuoteController;
use App\Http\Controllers\Api\MobSupplierController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});
Route::post('/login', action: [MobAuthController::class, 'login']);
Route::middleware('auth:sanctum')->group(function () {
    Route::get('/companies', [MobAuthController::class, 'getCompanies']);
    Route::get('/companies/{id}/branches', [MobAuthController::class, 'getBranches']);
    Route::post('/setup', [MobAuthController::class, 'setup']);
});

Route::middleware('auth:sanctum')->group(function () {
    Route::prefix('suppliers')->group(function () {
        Route::get('/', [MobSupplierController::class, 'index']);
        Route::post('/', [MobSupplierController::class, 'store']);
        Route::put('/{id}', [MobSupplierController::class, 'update']);
        Route::delete('/{id}', [MobSupplierController::class, 'destroy']);
        Route::get('/all', [MobSupplierController::class, 'allSuppliers']);
    });

    Route::resource('products', MobProductController::class);
    Route::get('products/all/{branchId}', [MobProductController::class,'allProducts']);
    Route::resource('quotes', MobQuoteController::class);
    Route::resource('categories', MobCategoryController::class);
    Route::get('expense-categories', [MobExpenseController::class, 'expenseCategory']);
    Route::resource('expenses', MobExpenseController::class);
});
