@extends('layouts.layoutapp')

@section('content')

    <div class="main-content">
        <div class="row">
            <div class="col-12">
                <div class="card mb-4 mx-4">
                    <div class="card-body">
                        <div class="d-flex justify-content-end align-items-center mb-3 px-3">
                            <form method="GET" action="{{ route('invoice-Report') }}" class="d-flex align-items-center">
                                <div class="form-group me-3">
                                    <input type="date" class="form-control @error('start_date') is-invalid @enderror"
                                        id="start_date" name="start_date"
                                        value="{{ old('start_date', request()->get('start_date')) }}">

                                    <!-- Display error message for start_date -->
                                    @error('start_date')
                                        <div class="invalid-feedback">
                                            {{ $message }}
                                        </div>
                                    @enderror
                                </div>

                                <div class="form-group me-3">
                                    <input type="date" class="form-control @error('end_date') is-invalid @enderror"
                                        id="end_date" name="end_date"
                                        value="{{ old('end_date', request()->get('end_date')) }}">

                                    <!-- Display error message for end_date -->
                                    @error('end_date')
                                        <div class="invalid-feedback">
                                            {{ $message }}
                                        </div>
                                    @enderror
                                </div>

                                <div class="form-group me-3">

                                    <select name="status" id="status" class="form-control">
                                        <option value="">Filters</option>
                                        <option value=" " {{ request()->get('status') == 'all' ? 'selected' : '' }}>All
                                        </option>
                                        <option value="Y" {{ request()->get('status') == 'gst' ? 'selected' : '' }}>GST
                                        </option>
                                        <option value="N" {{ request()->get('status') == 'non_gst' ? 'selected' : '' }}>
                                            Non-GST
                                        </option>

                                    </select>
                                </div>
                                <button type="submit" class="btn btn-primary">Filter</button>
                            </form>
                        </div>

                        <div class="table-responsive">
                            <table class="table align-items-center mb-0 table-hover text-sm" id="myTable">
                                <thead>
                                    <tr>
                                        <th class="text-uppercase text-secondary  font-weight-bolder opacity-7">Invoice ID
                                        </th>
                                        <th class="text-uppercase text-secondary  font-weight-bolder opacity-7">Client Name
                                        </th>
                                        <th class="text-uppercase text-secondary  font-weight-bolder opacity-7">Branch Name
                                        </th>
                                        <th class="text-uppercase text-secondary  font-weight-bolder opacity-7">Invoice Date
                                        </th>
                                        <th class="text-uppercase text-secondary  font-weight-bolder opacity-7">Due Date
                                        </th>
                                        <th class="text-uppercase text-secondary  font-weight-bolder opacity-7">GST</th>
                                        <th class="text-uppercase text-secondary  font-weight-bolder opacity-7">Amount</th>
                                        <th class="text-uppercase text-secondary  font-weight-bolder opacity-7">Final Amount
                                        </th>
                                        <th class="text-uppercase text-secondary  font-weight-bolder opacity-7">Discount
                                            Type</th>
                                        <th class="text-uppercase text-secondary  font-weight-bolder opacity-7">Discount
                                        </th>
                                        <th class="text-uppercase text-secondary  font-weight-bolder opacity-7">Status</th>
                                    </tr>
                                </thead>
                                <tbody>

                                    @foreach ($results as $data)
                                        <tr>
                                            <td class="ps-4">
                                                <p class="text-xs font-weight-bold mb-0">{{ $data->invoice_id ?? '' }}</p>
                                            </td>
                                            <td class="ps-4">
                                                <p class="text-xs font-weight-bold mb-0">
                                                    {{ $data->client ? $data->client->user->name : ''}}
                                                </p>
                                            </td>
                                            <td class="ps-4">
                                                <p class="text-xs font-weight-bold mb-0">{{ $data->branch->name ?? '' }}</p>
                                            </td>
                                            <td class="ps-4">
                                                <p class="text-xs font-weight-bold mb-0">
                                                    {{ $data->invoice_date ? \Carbon\Carbon::parse($data->invoice_date)->format('d-m-Y') : '' }}
                                                </p>
                                            </td>
                                            <td class="ps-4">
                                                <p class="text-xs font-weight-bold mb-0">
                                                    {{ $data->due_date ? \Carbon\Carbon::parse($data->due_date)->format('d-m-Y') : '' }}
                                                </p>
                                            </td>
                                            <td class="ps-4">
                                                <p class="text-xs font-weight-bold mb-0">{{ $data->gst == 'Y' ? 'Yes' : 'NO' }}
                                                </p>
                                            </td>
                                            <td class="ps-4">
                                                <p class="text-xs font-weight-bold mb-0">{{ $data->amount ?? '' }}</p>
                                            </td>
                                            <td class="ps-4">
                                                <p class="text-xs font-weight-bold mb-0">{{ $data->final_amount ?? '' }}</p>
                                            </td>
                                            <td class="ps-4">
                                                <p class="text-xs font-weight-bold mb-0">
                                                    {{ $data->discount_type === null ? 'Not Set' : ($data->discount_type == 1 ? 'Fixed' : 'Percentage') }}
                                                </p>
                                            </td>
                                            <td class="ps-4">
                                                <p class="text-xs font-weight-bold mb-0">{{ $data->discount ?? '' }}</p>
                                            </td>
                                            <td class="ps-4">
                                                <p class="text-xs font-weight-bold mb-0">
                                                    {{$statusList[$data->status] ?? 'Unknown' }}
                                                </p>
                                            </td>
                                        </tr>
                                    @endforeach

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
{{-- @push('scripts')
<script>
    window.onload = function () {
        document.getElementById('start_date').value = '';
        document.getElementById('end_date').value = '';
        document.getElementByID('status').value = '';
    }
</script>
@endpush --}}