<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <link rel="stylesheet" href="{{asset('assets/css/style.css')}}">
    <link rel="stylesheet" href="{{asset('assets/css/bootstrap.min.css')}}">
    <link rel="stylesheet" href="{{asset('assets/css/soft-ui-dashboard.css')}}">
    <link rel="stylesheet" href="{{asset('assets/css/soft-ui-dashboard.min.css')}}">
    <link rel="stylesheet" href="{{asset('assets/css/soft-ui-dashboard.css.map')}}">
    <link rel="stylesheet" href="{{asset('assets/css/nucleo-svg.css')}}">
    <title>Invoice</title>
    <style>
        /* Basic reset */
        body,
        html {
            margin: 0;
            padding: 0;
            font-family: Arial, sans-serif;
            background-color: rgb(253, 253, 253) !important;
        }

        /* Thermal printer page size */
        .invoice-wrapper {
            width: 80mm;
            /* Thermal printer width */
            margin: 0 auto;
            padding: 5mm;
            font-size: 12px;
        }

        /* Centering content */
        .header {
            text-align: center;
        }

        .invoice-logo img {
            width: 70%;
            /* Adjust logo to fit thermal print */
            max-width: 100%;
            object-fit: contain;
        }

        .invoice-title {
            font-size: 14px;
            font-weight: bold;
            margin-top: 5mm;
        }

        /* Invoice From / To Table */
        .info-section {
            margin-top: 10mm;
        }

        .info-section table {
            width: 100%;
            border: none;
            margin-top: 5mm;
        }

        .info-section td {
            padding: 2mm 0;
        }

        .info-section h4 {
            font-size: 14px;
            margin-bottom: 2mm;
        }

        .info-section p {
            font-size: 12px;
            margin: 2px 0;
        }

        /* Table styles for item details */
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 5mm;
        }

        table th,
        table td {
            font-size: 12px;
            padding: 2mm;
            text-align: left;
        }

        table th {
            background-color: #f2f2f2;
        }

        table td {
            text-align: right;
        }

        /* Total Section */
        .total-section td {
            font-weight: bold;
        }

        /* Footer Note */
        .footer-note {
            font-size: 8px;
            color: #888;
            margin-top: 10mm;
            text-align: center;
        }

        /* Hide buttons during print */
        @media print {
            .invoice-btn-section {
                display: none;
            }
        }

        /* Print settings for thermal printer */
        @media print {
            body {
                margin: 0;
                padding: 0;
                font-size: 12px;
            }

            .invoice-wrapper {
                width: 80mm;
                /* Keep it within thermal printer width */
                page-break-before: always;
            }

            /* Make sure text is properly aligned for printing */
            .info-section {
                margin-top: 10mm;
            }

            .info-section table {
                width: 100%;
            }

            .info-section td {
                width: 50%;
                vertical-align: top;
            }
        }

        .form-select {
            margin-bottom: 1rem !important;
        }
    </style>
</head>

<body>

    <div class="invoice-wrapper" id="invoice_wrapper">
        <!-- Header with logo and invoice title -->
        <div class="header">
            <div class="invoice-logo">
                <img src="{{ getFileUrl($settings->logo ? $settings->logo : 'storage/logo/logo_invoice.png') }}"
                    alt="logo">
            </div>
            <div class="invoice-title">Quote #{{ $addedInvoice->quote_id ?? '' }}</div>
            <div class="invoice-title">Quote Date:
                {{ $addedInvoice->quote_date ? \Carbon\Carbon::parse($addedInvoice->quote_date)->format('d-m-Y') : '' }}
            </div>
        </div>

        <!-- Sender/Receiver Information in Table format -->
        <div class="info-section">
            <table style="width: 100%; border: none;">
                <tr>
                    <td style="text-align: left; vertical-align: top; padding-right: 10px;">
                        <h4>Quote From:</h4>
                        <p>{{ $settings->company_name ?? '' }}</p>
                        <p>{{ $settings->address ?? '' }}</p>
                        <p>{{ $settings->email ?? '' }}</p>
                        <p>(+91) {{ $settings->phone ?? '' }}</p>
                    </td>
                    <td style="text-align: left; vertical-align: top;">
                        <h4>Quote To:</h4>
                        <p>{{ $addedInvoice->client->user->name ?? '' }}</p>
                        <p>(+91) {{ $addedInvoice->client->user->phone ?? '' }}</p>
                    </td>
                </tr>
            </table>
        </div>


        <!-- Invoice Details Table -->
        <table>
            <thead>
                <tr>
                    <th>No.</th>
                    <th>Item Description</th>
                    <th>Price</th>
                    <th>Quantity</th>
                    <th>Amount</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($addedInvoice->quotesItem as $index => $data)
                    <tr>
                        <td>{{ $index + 1 }}</td>
                        <td>{{ $data->product_name ?? '' }}</td>
                        <td>{{ $data->price ?? '' }}</td>
                        <td>{{ $data->quantity ?? '' }}</td>
                        <td>{{ $data->total ?? '' }}</td>
                    </tr>
                @endforeach
                <tr>
                    <td colspan="4" style="text-align: right;">SubTotal</td>
                    <td>{{ $addedInvoice->amount ?? '0' }}</td>
                </tr>
                <tr>
                    <td colspan="4" style="text-align: right;">Discount</td>
                    <td> @php
                        $totalDiscount = 0;
                        $total = $addedInvoice->amount;
                        if ($addedInvoice->discount_type == 1) {
                            $totalDiscount = $addedInvoice->discount;
                        } elseif ($addedInvoice->discount_type == 2) {
                            $discountAmount = ($total * $addedInvoice->discount)
                                / 100;
                            $totalDiscount = $discountAmount;
                        } else {
                            $totalDiscount = 0;
                        }
                    @endphp
                        ₹ {{number_format($totalDiscount ?? 0, 2)}}</td>
                    </td>
                </tr>
                <tr>
                    <td colspan="4" style="text-align: right;">Grand Total</td>
                    <td><strong>{{number_format(floor($addedInvoice->amount) ?? 0, 2)}}</strong></td>
                </tr>
            </tbody>
        </table>

        <div class="invoice-btn-section">
            <div class="d-flex gap-2">
                <select name="paper_size" id="paper_size" class="form-select">
                    <option value="">Select Standard paper size</option>
                    @foreach ($paper as $item)
                        <option value="{{$item->id}}">{{$item->name}}</option>
                    @endforeach
                </select>
            </div>
            <div class="d-flex gap-2">
                <a href="javascript:window.print()" class="btn">
                    <i class="fa fa-print"></i> Print Quotes
                </a>
                <a id="invoice_download_btn" class="btn">
                    <i class="fa fa-download"></i> Download Quotes
                </a>
            </div>
            <div class="d-flex gap-2">
                <a href='{{route('quotes-index')}}' id="cancel-btn" class="btn">
                    <i class="fa fa-arrow-left"></i> Back
                </a>
            </div>

        </div>
    </div>

    <!-- JS Scripts for Downloading as PDF -->
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script src="{{asset('assets/js/jspdf.min.js')}}"></script>
    <script src="{{asset('assets/js/html2canvas.js')}}"></script>

    <script>
        $(function () {
            $(document).on('click', '#invoice_download_btn', function () {
                // Hide the print and download buttons before generating the PDF
                $(".invoice-btn-section").hide();

                var content = $("#invoice_wrapper")[0];

                // The actual dimensions of the thermal printer in mm
                var contentWidth = content.offsetWidth;
                var contentHeight = content.offsetHeight;

                // Set the thermal printer width (80mm) and calculate the height dynamically
                var pdfWidth = 80; // 80mm paper width
                var pdfHeight = (contentHeight * pdfWidth) / contentWidth; // Maintain aspect ratio

                // Ensure the content is rendered properly in the canvas
                html2canvas(content, {
                    allowTaint: true,
                    scale: 2,  // Increased scale for better quality
                    useCORS: true
                }).then(function (canvas) {
                    var imgData = canvas.toDataURL("image/jpeg", 1.0);

                    // Initialize jsPDF with the correct paper size
                    var pdf = new jsPDF('p', 'mm', [pdfWidth, pdfHeight]);

                    // Add image to PDF at 0,0 position
                    pdf.addImage(imgData, 'JPEG', 0, 0, pdfWidth, pdfHeight);

                    // Save the PDF with the invoice number as the file name
                    pdf.save("{{$addedInvoice->quote_id}}.pdf");

                    // Show the buttons again after generating the PDF
                    $(".invoice-btn-section").show();
                });
            });
        });
    </script>
    <script>
        $(function () {
            $(document).on('change', '#paper_size', function () {
                const paperId = $('#paper_size').val();
                const invoiceId = "{{ $addedInvoice->id }}";

                window.location.href = "{{ route('quote-pdf', ['id' => 'INVOICE_ID_PLACEHOLDER']) }}".replace('INVOICE_ID_PLACEHOLDER', invoiceId) + "?paperId=" + paperId;
            });
        });
    </script>
</body>

</html>