@extends('layouts.layoutapp')

@section('content')
<div class="main-content">
    <div class="row">
        <div class="col-12">
            <div class="card mb-4 mx-4">
                <div class="card-header pb-0">
                    <div class="d-flex flex-row justify-content-between">
                        <div>
                            <h5 class="mb-0">Purchase Product</h5>
                        </div>                        
                    </div>
                </div>

                <div class="card-body">
                    <form action="{{ route('product-stock-save') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        <input type="hidden" name="product_id" value="{{$product->id}}">
                        <div class="row">
                            <div class="col-lg-6">
                                <div class="row">
                                    <div class="col-lg-6 mb-3">
                                        <label for="name" class="form-label">Name:</label>
                                        <input type="text" id="name" class="form-control" 
                                               value="{{ $product->name }}" readonly>
                                    </div>
                                    <div class="col-lg-6 mb-3">
                                        <label for="productCode" class="form-label">Product Code:</label>
                                        <input type="text" id="productCode" class="form-control" 
                                               value="{{ $product->code }}" readonly>
                                    </div>
                                                         
                                    <div class="col-lg-6 mb-3">
                                        <label for="unit_price" class="form-label">Selling Price / Unit:</label>
                                        <input type="number" id="unit_price" name="unit_price" class="form-control" 
                                               placeholder="0.00" min="0" step="0.01" value="{{old('unit_price')}}" required>
                                    </div>
                                    <div class="col-lg-6 mb-3">
                                        <label for="margin_price" class="form-label">Margin Price / Unit:</label>
                                        <input type="number" id="margin_price" name="margin_price" class="form-control" 
                                               placeholder="0.00" min="0" step="0.01" value="{{old('margin_price')}}" required 
                                               onchange="updateTotalAmount()">
                                    </div>
                                      
                                    <div class="col-lg-6 mb-3">
                                        <label for="category_id" class="form-label">Category:</label>
                                        <select class="form-select" disabled>
                                            <option>{{ $product->category->name }}</option>
                                        </select>
                                    </div>
                                    <div class="col-lg-6 mb-3">
                                        <label for="supplier_id" class="form-label">Supplier:</label>
                                        <select name="supplier_id" class="form-select" required>
                                            <option value="" selected disabled>Select Supplier</option>
                                            @foreach ($suppliers as $supplier)
                                                <option value="{{ $supplier->id }}" {{ old('supplier_id') == $supplier->id ? 'selected' : '' }}>
                                                    {{ $supplier->supplier_name }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="col-lg-12 mb-3">
                                        <label for="description" class="form-label">Description:</label>
                                        <textarea name="description" class="form-control" rows="2"
                                                  placeholder="Enter purchase description (optional)"></textarea>
                                    </div>
                                              
                                </div>
                            </div>
                            
                            <div class="col-lg-6">
                                <div class="row">
                                    <div class="col-lg-6 mb-3">
                                        <label for="hsnCode" class="form-label">HSN Code:</label>
                                        <input type="text" id="hsnCode" name="hsnCode" class="form-control" 
                                               value="{{ $product->hsn_code }}" readonly placeholder="Enter HSN code" >                                       
                                    </div>
                                    <div class="col-lg-6 mb-3">
                                        <label for="qty" class="form-label">Quantity:</label>
                                        <input type="number" id="qty" name="qty" class="form-control" 
                                               placeholder="Enter quantity" min="1" step="1" value="{{old('qty')}}" required>
                                    </div>  
                                    <div class="col-12 mb-3">
                                        <label class="form-label">Products Image:</label>
                                        <div class="d-flex align-items-center">
                                            <div class="avatar-upload me-5">
                                                <div class="avatar-preview">
                                                    <img src="{{ $product->products_image ? getFileUrl( $product->products_image) : asset('assets/img/logos/Product.png') }}" 
                                                        alt="Product Image" class="img-fluid" 
                                                        style="width: 150px; height: 150px; object-fit: cover;">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    
                                  
                                    
                              
                                </div>
                            </div>
                        </div>
                        
                        <hr>
                        
                        <div class="row p-2">
                            <h5 class="me-3">Payment Details</h5>
                            
                            <div class="d-flex align-items-center">
                                <label for="total_amount" class="form-label mx-4">Total Amount:</label>
                                <div class="col-md-3 mb-3">
                                    <input type="number" name="total_amount" id="total_amount" class="form-control" 
                                           placeholder="0.00" step="0.01" readonly>
                                </div>
                            </div>
                            
                            <div class="col-md-3 mb-3">
                                <label for="pay_date" class="form-label">Payment Date</label>
                                <input type="date" name="pay_date" id="pay_date" class="form-control" 
                                       value="{{ date('Y-m-d') }}">
                            </div>
                            <div class="col-md-3 mb-3">
                                <label for="upi" class="form-label">UPI</label>
                                <input type="number" name="upi" id="upi" class="form-control" 
                                       placeholder="0.00" min="0" value="{{old('upi')}}" step="0.01">
                            </div>
                            <div class="col-md-3 mb-3">
                                <label for="cash" class="form-label">Cash</label>
                                <input type="number" name="cash" id="cash" class="form-control" 
                                       placeholder="0.00" min="0" value="{{old('cash')}}" step="0.01">
                            </div>
                            <div class="col-md-3 mb-3">
                                <label for="online" class="form-label">Online</label>
                                <input type="number" name="online" id="online" class="form-control" 
                                       placeholder="0.00" min="0" value="{{old('online')}}" step="0.01">
                            </div>
                        </div>
                        
                        <div class="modal-footer">
                            <button type="submit" class="btn btn-primary">Save Purchase</button>
                            <a href="{{ route('product-index') }}" class="btn btn-secondary">Cancel</a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    function updateTotalAmount() {
        const marginPrice = parseFloat(document.getElementById('margin_price').value) || 0;
        const qty = parseFloat(document.getElementById('qty').value) || 0;
        const totalAmount = (marginPrice * qty).toFixed(2);
        document.getElementById('total_amount').value = totalAmount;
    }
    
    // Initialize total amount calculation on page load
    document.addEventListener('DOMContentLoaded', function() {
        // Set up event listeners for quantity and price changes
        document.getElementById('qty').addEventListener('change', updateTotalAmount);
        document.getElementById('margin_price').addEventListener('change', updateTotalAmount);
        
        // Initialize calculation
        updateTotalAmount();
    });
</script>
@endpush