@extends('layouts.layoutapp')

@section('content')
<div class="main-content">
    <div class="row">
        <div class="col-12">
            <div class="card mb-4 mx-4">
                <div class="card-header pb-0">
                    <div class="d-flex flex-row justify-content-between">
                        <div>
                            <h5 class="mb-0">Edit Product</h5>
                        </div>                      
                    </div>
                </div>
                
                <div class="card-body">
                    <form action="{{ route('product-update') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                    <input type="hidden" name="product_id" value="{{$product->id}}">                        
                        <div class="row">
                            <div class="col-lg-6">
                                <div class="row">
                                    <div class="col-lg-6 mb-3">
                                        <label for="name" class="form-label">Name:</label>
                                        <input type="text" id="name" name="name" class="form-control" 
                                               value="{{ old('name', $product->name) }}" placeholder="Enter product name" required>
                                        @error('name') <span class="text-danger">{{ $message }}</span> @enderror
                                    </div>
                                    <div class="col-lg-6 mb-3">
                                        <label for="productCode" class="form-label">Product Code:</label>
                                        <input type="text" id="productCode" name="productCode" class="form-control" 
                                               value="{{ old('productCode', $product->code) }}" placeholder="Enter product code" required>
                                        @error('productCode') <span class="text-danger">{{ $message }}</span> @enderror
                                    </div>                                   
                                    
                                    <div class="col-lg-6 mb-3">
                                        <label for="unit_price" class="form-label">Selling Price / Unit:</label>
                                        <input type="number" id="unit_price" name="unit_price" class="form-control" 
                                               value="{{ old('unit_price', $product->unit_price) }}" placeholder="0.00" min="0" step="0.01" required>
                                        @error('unit_price') <span class="text-danger">{{ $message }}</span> @enderror
                                    </div>
                                    <div class="col-lg-6 mb-3">
                                        <label for="margin_price" class="form-label">Margin Price / Unit:</label>
                                        <input type="number" id="margin_price" name="margin_price" class="form-control" 
                                               value="{{ old('margin_price', $product->margin_price) }}" placeholder="0.00" min="0" step="0.01" required>
                                        @error('margin_price') <span class="text-danger">{{ $message }}</span> @enderror
                                    </div>
                                    <div class="col-lg-6 mb-3">
                                        <label for="category_id" class="form-label">Category:</label>
                                        <select name="category_id" class="form-select" required>
                                            <option value="" selected disabled>Select Category</option>
                                            @foreach ($categories as $category)
                                                <option value="{{ $category->id }}" {{ (old('category_id', $product->category_id) == $category->id) ? 'selected' : '' }}>{{ $category->name }}</option>
                                            @endforeach
                                        </select>
                                        @error('category_id') <span class="text-danger">{{ $message }}</span> @enderror
                                    </div>
                                    <div class="col-lg-6 mb-3">
                                        <label for="supplier_id" class="form-label">Supplier:</label>
                                        <select name="supplier_id" class="form-select" required>
                                            <option value="" selected disabled>Select Supplier</option>
                                            @foreach ($suppliers as $supplier)
                                                <option value="{{ $supplier->id }}" {{ (old('supplier_id', $product->supplier_id) == $supplier->id) ? 'selected' : '' }}>{{ $supplier->supplier_name }}</option>
                                            @endforeach
                                        </select>
                                        @error('supplier_id') <span class="text-danger">{{ $message }}</span> @enderror
                                    </div>
                                    
                                    <div class="col-lg-12 mb-3">
                                        <label for="description" class="form-label">Description:</label>
                                        <textarea id="description" name="description" class="form-control" rows="2"
                                                  placeholder="Enter product description (optional)">{{ old('description', $product->description) }}</textarea>
                                        @error('description') <span class="text-danger">{{ $message }}</span> @enderror
                                    </div>
                                </div>
                            </div>
                            
                            <div class="col-lg-6">
                                <div class="row">
                                    <div class="col-lg-6 mb-3">
                                        <label for="hsnCode" class="form-label">HSN Code:</label>
                                        <input type="text" id="hsnCode" name="hsnCode" class="form-control" 
                                               value="{{ old('hsnCode', $product->hsn_code) }}" placeholder="Enter HSN code" >
                                        @error('hsnCode') <span class="text-danger">{{ $message }}</span> @enderror
                                    </div>
                                    <div class="col-lg-6 mb-3">
                                        <label for="qty" class="form-label">Quantity:</label>
                                        <input type="number" id="qty" name="qty" class="form-control" 
                                               value="{{ old('qty', $product->qty) }}" placeholder="0" min="0" step="1" required >
                                        @error('qty') <span class="text-danger">{{ $message }}</span> @enderror
                                    </div>
                                    <div class="col-12 mb-3">
                                        <label for="product_image" class="form-label">Products Image:</label>
                                        <div class="d-flex align-items-center">
                                            <div class="avatar-upload me-5">
                                                <div class="avatar-preview">
                                                    <img id="imagePreview" src="{{ $product->products_image ? getFileUrl($product->products_image) : asset('assets/img/logos/Product.png') }}" 
                                                        alt="Product Image" class="img-fluid" 
                                                        style="width: 150px; height: 150px; object-fit: cover;">
                                                </div>
                                            </div>
                                            <div class="avatar-edit">
                                                <input type="file" id="product_image" name="product_image" class="form-control file-upload-input" 
                                                    accept="image/*" onchange="previewImage(this)">
                                                <small class="text-muted">Upload new image (max 2MB)</small>
                                            </div>
                                        </div>
                                        @error('product_image') <span class="text-danger">{{ $message }}</span> @enderror
                                    </div>
                                    
                                    
                                </div>
                            </div>
                        </div>                                            
                        
                        <div class="modal-footer">
                            <button type="submit" class="btn btn-primary">Update Product</button>
                            <a href="{{ route('product-index') }}" class="btn btn-secondary">Cancel</a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    function previewImage(input) {
        if (input.files && input.files[0]) {
            const reader = new FileReader();
            reader.onload = function(e) {
                document.getElementById('imagePreview').src = e.target.result;
            }
            reader.readAsDataURL(input.files[0]);
        }
    }    
</script>
@endpush