@extends('layouts.layoutapp')

@section('content')
<div class="main-content">
    <div class="row">
        <div class="col-12">
            <div class="card mb-4 mx-4">
                <div class="card-header pb-0">
                    <div class="d-flex flex-row justify-content-between">
                        <div>
                            <h5 class="mb-0">Add New Product</h5>
                        </div>                        
                    </div>
                </div>
                
                <div class="card-body">
                    <form action="{{ route('product-store') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        
                        <div class="row">
                            <div class="col-lg-6">
                                <div class="row">
                                    <div class="col-lg-6 mb-3">
                                        <label for="name" class="form-label">Name:</label>
                                        <input type="text" id="name" name="name" class="form-control" 
                                               value="{{ old('name') }}" placeholder="Enter product name" required>
                                        @error('name') <span class="text-danger">{{ $message }}</span> @enderror
                                    </div>
                                    <div class="col-lg-6 mb-3">
                                        <label for="productCode" class="form-label">Product Code:</label>
                                        <input type="text" id="productCode" name="productCode" class="form-control" 
                                               value="{{ old('productCode') }}" placeholder="Enter product code" required>
                                        @error('productCode') <span class="text-danger">{{ $message }}</span> @enderror
                                    </div>
                                    
                                    
                                    <div class="col-lg-6 mb-3">
                                        <label for="unit_price" class="form-label">Selling Price / Unit:</label>
                                        <input type="number" id="unit_price" name="unit_price" class="form-control" 
                                               value="{{ old('unit_price') }}" placeholder="0.00" min="0" step="0.01" required>
                                        @error('unit_price') <span class="text-danger">{{ $message }}</span> @enderror
                                    </div>
                                    <div class="col-lg-6 mb-3">
                                        <label for="margin_price" class="form-label">Margin Price / Unit:</label>
                                        <input type="number" id="margin_price" name="margin_price" class="form-control" 
                                               value="{{ old('margin_price') }}" placeholder="0.00" min="0" step="0.01" required
                                               onchange="updateTotalAmount()">
                                        @error('margin_price') <span class="text-danger">{{ $message }}</span> @enderror
                                    </div>
                                    <div class="col-lg-6 mb-3">
                                        <label for="category_id" class="form-label">Category:</label>
                                        <select name="category_id" class="form-select" required>
                                            <option value="" selected disabled>Select Category</option>
                                            @foreach ($categories as $category)
                                                <option value="{{ $category->id }}" {{ old('category_id') == $category->id ? 'selected' : '' }}>{{ $category->name }}</option>
                                            @endforeach
                                        </select>
                                        @error('category_id') <span class="text-danger">{{ $message }}</span> @enderror
                                    </div>
                                    <div class="col-lg-6 mb-3">
                                        <label for="supplier_id" class="form-label">Supplier:</label>
                                        <select name="supplier_id" class="form-select" required>
                                            <option value="" selected disabled>Select Supplier</option>
                                            @foreach ($suppliers as $supplier)
                                                <option value="{{ $supplier->id }}" {{ old('supplier_id') == $supplier->id ? 'selected' : '' }}>{{ $supplier->supplier_name }}</option>
                                            @endforeach
                                        </select>
                                        @error('supplier_id') <span class="text-danger">{{ $message }}</span> @enderror
                                    </div>
                                    
                                    <div class="col-lg-12 mb-3">
                                        <label for="description" class="form-label">Description:</label>
                                        <textarea id="description" name="description" class="form-control" rows="2"
                                                  placeholder="Enter product description (optional)">{{ old('description') }}</textarea>
                                        @error('description') <span class="text-danger">{{ $message }}</span> @enderror
                                    </div>
                                </div>
                            </div>
                            
                            <div class="col-lg-6">
                                <div class="row">
                                    <div class="col-lg-6 mb-3">
                                        <label for="hsnCode" class="form-label">HSN Code:</label>
                                        <input type="text" id="hsnCode" name="hsnCode" class="form-control" 
                                               value="{{ old('hsnCode') }}" placeholder="Enter HSN code" >
                                        @error('hsnCode') <span class="text-danger">{{ $message }}</span> @enderror
                                    </div>
                                    <div class="col-lg-6 mb-3">
                                        <label for="qty" class="form-label">Quantity:</label>
                                        <input type="number" id="qty" name="qty" class="form-control" 
                                               value="{{ old('qty') }}" placeholder="0" min="0" step="1" required
                                               onchange="updateTotalAmount()">
                                        @error('qty') <span class="text-danger">{{ $message }}</span> @enderror
                                    </div>
                                    
                                    <div class="col-12 mb-3">
                                        <label for="product_image" class="form-label">Products Image:</label>
                                        <div class="d-flex align-items-center">
                                            <div class="avatar-upload me-5">
                                                <div class="avatar-preview">
                                                    <img id="imagePreview" src="{{ asset('assets/img/logos/Product.png') }}" 
                                                        alt="Default Products Image" class="img-fluid" 
                                                        style="width:auto; max-width: 250px; height: 150px; ">
                                                </div>
                                            </div>
                                            <div class="avatar-edit">
                                                <input type="file" id="product_image" name="product_image" class="form-control file-upload-input" 
                                                    accept="image/*" onchange="previewImage(this)">
                                                <small class="text-muted">Upload product image (max 2MB)</small>
                                            </div>
                                        </div>
                                        @error('product_image') <span class="text-danger">{{ $message }}</span> @enderror
                                    </div>
                                    
                                    
                                </div>
                            </div>
                        </div>
                        
                        <hr>
                        
                        <div class="row p-2">
                            <h5 class="me-3">Payment Details</h5>
                            
                            <div class="d-flex align-items-center">
                                <label for="total_amount" class="form-label mx-4">Total Amount:</label>
                                <div class="col-md-3 mb-3">
                                    <input type="number" name="total_amount" id="total_amount" class="form-control" 
                                           value="{{ old('total_amount') }}" placeholder="0.00" step="0.01" readonly>
                                </div>
                            </div>
                            
                            <div class="col-md-3 mb-3">
                                <label for="pay_date" class="form-label">Payment Date</label>
                                <input type="date" name="pay_date" id="pay_date" class="form-control" 
                                       value="{{ old('pay_date') }}" placeholder="Select payment date">
                            </div>
                            <div class="col-md-3 mb-3">
                                <label for="upi" class="form-label">UPI</label>
                                <input type="number" name="upi" id="upi" class="form-control" 
                                       value="{{ old('upi') }}" placeholder="0.00" min="0" step="0.01">
                            </div>
                            <div class="col-md-3 mb-3">
                                <label for="cash" class="form-label">Cash</label>
                                <input type="number" name="cash" id="cash" class="form-control" 
                                       value="{{ old('cash') }}" placeholder="0.00" min="0" step="0.01">
                            </div>
                            <div class="col-md-3 mb-3">
                                <label for="online" class="form-label">Online</label>
                                <input type="number" name="online" id="online" class="form-control" 
                                       value="{{ old('online') }}" placeholder="0.00" min="0" step="0.01">
                            </div>
                        </div>
                        
                        <div class="modal-footer">
                            <button type="submit" class="btn btn-primary">Save Product</button>
                            <a href="{{ route('product-index') }}" class="btn btn-secondary">Cancel</a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    function previewImage(input) {
        if (input.files && input.files[0]) {
            const reader = new FileReader();
            reader.onload = function(e) {
                document.getElementById('imagePreview').src = e.target.result;
            }
            reader.readAsDataURL(input.files[0]);
        }
    }
    
    function updateTotalAmount() {
        const marginPrice = parseFloat(document.getElementById('margin_price').value) || 0;
        const qty = parseFloat(document.getElementById('qty').value) || 0;
        const totalAmount = (marginPrice * qty).toFixed(2);
        document.getElementById('total_amount').value = totalAmount;
    }
    
    // Initialize total amount on page load
    document.addEventListener('DOMContentLoaded', function() {
        updateTotalAmount();
    });
</script>
@endpush