@extends('layouts.layoutapp')
@section('content')
    <div class="container">
        <div class="card">
            <form id="importForm" action="{{ route('product-import') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="card-header d-flex justify-content-between">
                    <div class="card-title">
                        <h4>Product Import</h4>
                    </div>
                    <div>
                        <a href="{{route('product-template')}}" class="btn btn-primary">
                            Download Template
                        </a>
                        <a href="{{route('product-index')}}" class="btn btn-secondary">Back</a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row align-items-center"> <!-- Added align-items-center here -->
                        <!-- First Column -->
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Upload File</label>
                                <input type="file" name="file" class="form-control" id="fileInput" required>
                            </div>
                        </div>
                        <!-- Second Column -->
                        <div class="col-md-6">
                            <div class="mb-3 mt-5">

                                <button class="btn bg-gradient-primary" type="submit">Upload</button>
                            </div>
                        </div>
                    </div>
                    <!-- Second Column -->
                    <div class="col-md-6">
                        <div class="mb-3">
                            @if (session('product_import_error'))

                                <ul class="mt-4">
                                    @foreach (session('product_import_error') as $error)
                                        <li class="text-danger">{{ $error }}</li>
                                    @endforeach
                                </ul>
                            @else
                                <p class="mt-4">No errors found.</p>
                            @endif
                        </div>
                    </div>

                </div>
            </form>
        </div>
    </div>
@endsection