@extends('layouts.layoutapp')
@section('content')
    <div>
        <!-- Main Wrapper Div for Livewire Component -->
        <div class="row m-2">
            <!-- Total Staffs Card -->
            <div class="col-xl-4 col-sm-6 mb-xl-0 mb-4">
                <div class="card" style="background: linear-gradient(135deg, #d4d9dd, #e6e9f0);">
                    <div class="card-body p-3">
                        <div class="row">
                            <div class="col-8">
                                <div class="numbers">
                                    <p class="text-sm mb-0 text-capitalize font-weight-bold">Total Staffs</p>
                                    <h5 class="font-weight-bolder mb-0">
                                        {{$staff_count ?? 0}}
                                    </h5>
                                </div>
                            </div>
                            <div class="col-4 text-end">
                                <div class="icon icon-shape bg-gradient-primary shadow text-center border-radius-md">
                                    <i class="ni ni-single-02 text-lg opacity-10" aria-hidden="true"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Total Products Card -->
            <div class="col-xl-4 col-sm-6 mb-xl-0 mb-4">
                <div class="card" style="background: linear-gradient(135deg, #b3c6ff, #e6f0ff);">
                    <div class="card-body p-3">
                        <div class="row">
                            <div class="col-8">
                                <div class="numbers">
                                    <p class="text-sm mb-0 text-capitalize font-weight-bold">Total Products</p>
                                    <h5 class="font-weight-bolder mb-0">
                                        {{$product_count ?? 0}}
                                    </h5>
                                </div>
                            </div>
                            <div class="col-4 text-end">
                                <div class="icon icon-shape bg-gradient-primary shadow text-center border-radius-md">
                                    <i class="ni ni-box-2 text-lg opacity-10" aria-hidden="true"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Total Invoices Card -->
            <div class="col-xl-4 col-sm-6 mb-xl-0 mb-4">
                <div class="card" style="background: linear-gradient(135deg, #f0e6d2, #f8f4e6);">
                    <div class="card-body p-3">
                        <div class="row">
                            <div class="col-8">
                                <div class="numbers">
                                    <p class="text-sm mb-0 text-capitalize font-weight-bold">Today's Invoices</p>
                                    <h5 class="font-weight-bolder mb-0">
                                        {{$invoice_count ?? 0}}
                                    </h5>
                                </div>
                            </div>
                            <div class="col-4 text-end">
                                <div class="icon icon-shape bg-gradient-primary shadow text-center border-radius-md">
                                    <i class="ni ni-single-copy-04 text-lg opacity-10" aria-hidden="true"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>


            <div class="col-xl-4 col-sm-6 mb-xl-0 mb-4 mt-2">
                <div class="card" style="background: linear-gradient(135deg, #92f4ef, #f8f4e6);">
                    <div class="card-body p-3">
                        <div class="row">
                            <div class="col-8">
                                <div class="numbers">
                                    <p class="text-sm mb-0 text-capitalize font-weight-bold">Total Selling Price</p>
                                    <h5 class="font-weight-bolder mb-0">
                                        {{ number_format($todayTotalSellingPrice ?? 0, 2) }}
                                    </h5>
                                </div>
                            </div>
                            <div class="col-4 text-end">
                                <div class="icon icon-shape bg-gradient-primary shadow text-center border-radius-md">
                                    <i class="ni ni-money-coins text-lg opacity-10" aria-hidden="true"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            @if(in_array(Auth::user()->user_flg , ['A','SU']))
                <div class="col-xl-4 col-sm-6 mb-xl-0 mb-4 mt-2">
                    <div class="card" style="background: linear-gradient(135deg, #e1f8a3, #f8f4e6);">
                        <div class="card-body p-3">
                            <div class="row">
                                <div class="col-8">
                                    <div class="numbers">
                                        <p class="text-sm mb-0 text-capitalize font-weight-bold">Total Margin Price</p>
                                        <h5 class="font-weight-bolder mb-0">
                                            {{number_format($todayTotalMarginPrice ?? 0, 2)}}
                                        </h5>
                                    </div>
                                </div>
                                <div class="col-4 text-end">
                                    <div class="icon icon-shape bg-gradient-primary shadow text-center border-radius-md">
                                        <i class="ni ni-shop text-lg opacity-10" aria-hidden="true"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-xl-4 col-sm-6 mb-xl-0 mb-4 mt-2">
                    <div class="card" style="background: linear-gradient(135deg, #62e0b4, #f8f4e6);">
                        <div class="card-body p-3">
                            <div class="row">
                                <div class="col-8">
                                    <div class="numbers">
                                        <p class="text-sm mb-0 text-capitalize font-weight-bold">Today's Profit</p>
                                        <h5 class="font-weight-bolder mb-0">
                                            {{number_format($todayTotalProfit ?? 0, 2)}}
                                        </h5>
                                    </div>
                                </div>
                                <div class="col-4 text-end">
                                    <div class="icon icon-shape bg-gradient-primary shadow text-center border-radius-md">
                                        <i class="ni ni-diamond text-lg opacity-10" aria-hidden="true"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            @endif
        </div>

        <!-- Graphs in a single row -->
        <div class="container mt-4">
            <div class="row">
                <!-- Left Graph: Products -->
                <div class="col-md-6 mb-4">
                    <div class="card" style="background: linear-gradient(135deg, #f3f6fc, #e1ebf7);">
                        <div class="card-body p-3">
                            <canvas id="chart-products"></canvas>
                        </div>
                    </div>
                </div>

                <!-- Right Graph: Sales -->
                <div class="col-md-6 mb-4">
                    <div class="card" style="background: linear-gradient(135deg, #f4e2d3, #ffefdf);">
                        <div class="card-body p-3">
                            <canvas id="chart-sales"></canvas>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

<!-- Core JS Files -->
@push('scripts')
    <script src="/assets/js/plugins/chartjs.min.js"></script>
    <script src="/assets/js/plugins/Chart.extension.js"></script>
    <script>
        // Products Graph: Bar Chart
        var ctx1 = document.getElementById("chart-products").getContext("2d");

        new Chart(ctx1, {
            type: "bar",
            data: {
                labels: ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"], // Months of the year
                datasets: [{
                    label: "Products Sold",
                    tension: 0.4,
                    borderWidth: 0,
                    pointRadius: 0,
                    backgroundColor: "rgba(120, 180, 255, 0.8)", // Soft blue tone
                    data: [
                        {{ $product_monthly_sales[1] ?? 0 }},
                        {{ $product_monthly_sales[2] ?? 0 }},
                        {{ $product_monthly_sales[3] ?? 0 }},
                        {{ $product_monthly_sales[4] ?? 0 }},
                        {{ $product_monthly_sales[5] ?? 0 }},
                        {{ $product_monthly_sales[6] ?? 0 }},
                        {{ $product_monthly_sales[7] ?? 0 }},
                        {{ $product_monthly_sales[8] ?? 0 }},
                        {{ $product_monthly_sales[9] ?? 0 }},
                        {{ $product_monthly_sales[10] ?? 0 }},
                        {{ $product_monthly_sales[11] ?? 0 }},
                        {{ $product_monthly_sales[12] ?? 0 }}
                    ], // Data for each month
                    maxBarThickness: 8
                }],
            },
            options: {
                responsive: true,
                tooltips: {
                    enabled: true,
                    mode: "index",
                    intersect: false,
                    backgroundColor: "rgba(0,0,0,0.7)",
                    titleFontColor: "#fff",
                    bodyFontColor: "#fff",
                    padding: 10
                },
                scales: {
                    yAxes: [{
                        gridLines: { display: false },
                        ticks: {
                            suggestedMin: 0,
                            beginAtZero: true,
                            fontSize: 14,
                            fontColor: "#000",
                            fontFamily: "Poppins",
                        },
                    }],
                    xAxes: [{
                        gridLines: { display: false },
                        ticks: {
                            display: true,
                            fontSize: 12,
                            fontColor: "#000",
                            fontFamily: "Poppins"
                        },
                    }],
                },
            },
        });

        // Sales Graph: Line Chart
        var ctx2 = document.getElementById("chart-sales").getContext("2d");

        var gradientStroke1 = ctx2.createLinearGradient(0, 230, 0, 50);
        gradientStroke1.addColorStop(1, 'rgba(240, 214, 167, 0.4)'); // Soft yellow-orange gradient
        gradientStroke1.addColorStop(0.2, 'rgba(255, 255, 255, 0.1)'); // Fading out to white
        gradientStroke1.addColorStop(0, 'rgba(255, 214, 61, 0)'); // Light gradient that blends out

        new Chart(ctx2, {
            type: "line",
            data: {
                labels: ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"], // Months of the year
                datasets: [{
                    label: "Sales Amount",
                    tension: 0.4,
                    borderWidth: 3,
                    pointRadius: 5,
                    borderColor: "rgba(251, 171, 49, 1)", // Gold color
                    backgroundColor: gradientStroke1,
                    data: [
                        {{ $sales_monthly[1] ?? 0 }},
                        {{ $sales_monthly[2] ?? 0 }},
                        {{ $sales_monthly[3] ?? 0 }},
                        {{ $sales_monthly[4] ?? 0 }},
                        {{ $sales_monthly[5] ?? 0 }},
                        {{ $sales_monthly[6] ?? 0 }},
                        {{ $sales_monthly[7] ?? 0 }},
                        {{ $sales_monthly[8] ?? 0 }},
                        {{ $sales_monthly[9] ?? 0 }},
                        {{ $sales_monthly[10] ?? 0 }},
                        {{ $sales_monthly[11] ?? 0 }},
                        {{ $sales_monthly[12] ?? 0 }}
                    ], // Data for each month
                    maxBarThickness: 6
                }],
            },
            options: {
                responsive: true,
                tooltips: {
                    enabled: true,
                    mode: "index",
                    intersect: false,
                    backgroundColor: "rgba(0,0,0,0.7)",
                    titleFontColor: "#fff",
                    bodyFontColor: "#fff",
                    padding: 10
                },
                scales: {
                    yAxes: [{
                        gridLines: {
                            borderDash: [2],
                            borderDashOffset: [2],
                            color: '#dee2e6',
                            zeroLineColor: '#dee2e6',
                            zeroLineWidth: 1,
                            drawBorder: false,
                        },
                        ticks: {
                            suggestedMin: 0,
                            beginAtZero: true,
                            fontSize: 12,
                            fontColor: "#000",
                            fontFamily: "Poppins",
                        },
                    }],
                    xAxes: [{
                        gridLines: { display: false },
                        ticks: {
                            fontSize: 12,
                            fontColor: '#000',
                            fontFamily: "Poppins"
                        },
                    }],
                },
            },
        });
    </script>
@endpush