@extends('layouts.layoutapp')

@section('content')
    <div class="main-content">
        <div class="row">
            <div class="col-12">
                <div class="card mb-4 mx-4">
                    <div class="card-header pb-0">
                        <h5 class="mb-0">Create New Company</h5>
                    </div>
                    <div class="card-body">
                        <form action="{{ route('company-store') }}" method="POST" enctype="multipart/form-data">
                            @csrf
                            <div class="row d-flex justify-content-between">
                                <!-- Left Side: Input Fields -->
                                <div class="col-lg-7">
                                    <div class="row">
                                        <div class="col-lg-6 mb-3">
                                            <label for="prefix" class="form-label">Application Prefix:</label>
                                            <input type="text" name="prefix" class="form-control"
                                                value="{{ old('prefix') }}" required>
                                            @error('prefix') <span class="text-danger">{{ $message }}</span> @enderror
                                        </div>
                                        <div class="col-lg-6 mb-3">
                                            <label for="application_name" class="form-label">Application Name:</label>
                                            <input type="text" name="application_name" class="form-control"
                                                value="{{ old('application_name') }}" required>
                                            @error('application_name') <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                        </div>
                                        <div class="col-lg-6 mb-3">
                                            <label for="name" class="form-label">Name:</label>
                                            <input type="text" name="name" class="form-control" value="{{ old('name') }}"
                                                required>
                                            @error('name') <span class="text-danger">{{ $message }}</span> @enderror
                                        </div>
                                        <div class="col-lg-6 mb-3">
                                            <label for="contact_number" class="form-label">Contact Number:</label>
                                            <input type="text" name="contact_number" class="form-control"
                                                value="{{ old('contact_number') }}">
                                            @error('contact_number') <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                        </div>
                                        <div class="col-lg-6 mb-3">
                                            <label for="email" class="form-label">Email:</label>
                                            <input type="email" name="email" class="form-control"
                                                value="{{ old('email') }}">
                                            @error('email') <span class="text-danger">{{ $message }}</span> @enderror
                                        </div>
                                        <div class="col-lg-6 mb-3">
                                            <label for="address" class="form-label">Address:</label>
                                            <input type="text" name="address" class="form-control"
                                                value="{{ old('address') }}">
                                            @error('address') <span class="text-danger">{{ $message }}</span> @enderror
                                        </div>
                                    </div>

                                </div>

                                <!-- Right Side: Logo Upload -->
                                <div class="col-lg-5">
                                    <div class="col-lg-8 mb-3">
                                        <label for="user_id" class="form-label">Default User:</label>
                                        <select name="user_id" id="user_id" class="form-select">
                                            <option value="">Select User</option>
                                            @foreach($users as $user)
                                                <option value="{{ $user->id }}" {{ old('user_id') == $user->id ? 'selected' : '' }}>{{ $user->name }}</option>
                                            @endforeach
                                        </select>
                                        @error('user_id') <span class="text-danger">{{ $message }}</span> @enderror
                                    </div>
                                    <!-- Logo section -->
                                    <div class="col-lg-12 mb-3">
                                        <label for="logo" class="form-label">Logo:</label>
                                        <div class="d-flex align-items-center mt-2" style="height: 50px; width: 100%;">
                                            <div class="avatar-upload me-3">
                                                <div class="avatar-preview">
                                                    <img id="logo-preview" src="{{ asset('assets/img/logos/Product.png') }}"
                                                        alt="Default Image" class="img-fluid mt-6"
                                                        style="height:125px; width:auto; max-width:250px;">
                                                </div>
                                            </div>
                                            <div class="avatar-edit">
                                                <input type="file" id="logo" name="logo"
                                                    class="file-upload-input form-control" accept="image/*"
                                                    onchange="previewImage(this, 'logo-preview')">
                                            </div>
                                        </div>
                                        @error('logo') <span class="text-danger">{{ $message }}</span> @enderror
                                    </div>

                                </div>


                            </div>
                            <div class="mt-4">
                                <button type="submit" class="btn btn-primary">Save Company</button>
                                <a href="{{ route('company-index') }}" class="btn btn-secondary">Cancel</a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
        <script>
            function previewImage(input, previewId) {
                if (input.files && input.files[0]) {
                    const reader = new FileReader();
                    reader.onload = function (e) {
                        document.getElementById(previewId).src = e.target.result;
                    }
                    reader.readAsDataURL(input.files[0]);
                }
            }
        </script>
    @endpush
@endsection