@extends('layouts.layoutapp')

@section('content')

    <div class="container">
        <div class="col-12">
            <div class="card mb-4 mx-4">
                <!-- Card Header -->
                <div class="card-header pb-0">
                    <div class="d-flex flex-row justify-content-between">
                        <div>
                            <h5 class="mb-0">All Branches</h5>
                        </div>
                        <a href="{{route('branch-add')}}" class="btn bg-gradient-primary btn-sm mb-0" type="button">+&nbsp;
                            New Branch</a>
                    </div>
                </div>

                <!-- Card Body -->
                <div class="card-body px-0 pt-0 pb-2">
                    {{-- <div class="d-flex align-items-center mb-3 px-3">
                        <div class="col-lg-3  px-3">
                            <select name="company_id" id="company" class="form-select">
                                <option value="">Select Company</option>
                                @foreach($companies as $company)
                                <option value="{{ $company->id }}">{{ $company->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div> --}}

                    <div class="table-responsive p-0">
                        <table class="table align-items-center mb-0 table-hover" id="myTable1">
                            <thead>
                                <tr>
                                    <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                        Company Name
                                    </th>
                                    <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                        Branch Name
                                    </th>
                                    <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                        logo
                                    </th>
                                    <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                        Phone
                                    </th>
                                    <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                        Email
                                    </th>
                                    <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                        Address
                                    </th>
                                    <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                        Actions
                                    </th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse ($branches as $data)
                                    <tr>
                                        <td class="ps-4">
                                            <p class="text-xs font-weight-bold mb-0">{{ $data->company_name ?? ''}}</p>
                                        </td>
                                        <td class="ps-4">
                                            <p class="text-xs font-weight-bold mb-0">{{ $data->name ?? ''}}</p>
                                        </td>
                                        <td class="ps-4">
                                            @if($data->logo)
                                                <img src="{{getFileUrl($data->logo) }}" alt="Image Preview" class="img-fluid"
                                                    style="width: 50px; height: 50px; object-fit: cover;">
                                            @else
                                                <img src="{{ asset('assets/img/logos/product.png' . $data->logo) }}"
                                                    alt="Image Preview" class="img-fluid"
                                                    style="width: 50px; height: 50px; object-fit: cover;">
                                            @endif
                                        </td>
                                        <td class="ps-4">
                                            <p class="text-xs font-weight-bold mb-0">{{ $data->phone ?? '' }}</p>
                                        </td>
                                        <td class="ps-4">
                                            <p class="text-xs font-weight-bold mb-0">{{ $data->email ?? '' }}</p>
                                        </td>
                                        <td class="ps-4">
                                            <p class="text-xs font-weight-bold mb-0">{{ $data->address ?? ''}}</p>
                                        </td>
                                        <td>
                                            <!-- Edit Icon -->
                                            <a href="{{ route('branch-edit', ['id' => $data->id]) }}" data-bs-toggle="tooltip"
                                                data-bs-original-title="Edit Branch">
                                                <i class="fa-solid fa-pen-to-square text-secondary"></i>
                                            </a>
                                            <span class="ms-2">
                                                <!-- Delete Icon and Form -->
                                                <form action="{{ route('branch-delete', ['id' => $data->id]) }}"
                                                    class="d-inline" method="POST" id="delete-form-{{ $data->id }}">
                                                    @csrf
                                                    @method('DELETE')
                                                    <i class="cursor-pointer fas fa-trash text-secondary"
                                                        onclick="confirmDelete({{ $data->id }})"></i>

                                                </form>
                                            </span>
                                        </td>

                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="7" class="text-center">
                                            <p class="text-xs font-weight-bold mb-0">No branches found.</p>
                                        </td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@push('scripts')
    <script>
        function confirmDelete(id) {
            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Yes, delete it!',
                cancelButtonText: 'Cancel'
            }).then((result) => {
                if (result.isConfirmed) {
                    document.getElementById('delete-form-' + id).submit();
                }
            });
        }
    </script>
    <script>
        $('#myTable1').DataTable();
    </script>
@endpush