@extends('layouts.layoutapp')

@section('content')
    <div class="page-header section-height-75">
        <div class="container">
            <div class="row">
                <div class="col-xl-4 col-lg-5 col-md-6 d-flex flex-column mx-auto">
                    <div class="card card-plain mt-8">
                        <div class="card-header pb-0 text-left bg-transparent">
                            <h3 class="font-weight-bolder text-info text-gradient">Select Company and Branch</h3>
                        </div>
                        <div class="card-body">
                            <form method="POST" action="{{ route('setup-submit') }}" role="form text-left">
                                @csrf
                                <div class="mb-3">
                                    <label for="company">Company</label>
                                    <div class="@error('company')border border-danger rounded-3 @enderror">
                                        <select id="company" name="company" class="form-select"
                                            onchange="loadBranches(this.value)">
                                            <option value="">Select Company</option>
                                            @forelse ($companies as $data)
                                                <option value="{{ $data->id }}" {{ old('company') == $data->id ? 'selected' : '' }}>
                                                    {{ $data->name }}
                                                </option>
                                            @empty
                                                <option value="">No company found</option>
                                            @endforelse
                                        </select>
                                    </div>
                                    @error('company')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="mb-3">
                                    <label for="branch">Branch</label>
                                    <div class="@error('branch')border border-danger rounded-3 @enderror">
                                        <select id="branch" name="branch" class="form-select" {{ empty(old('company')) ? 'disabled' : '' }}>
                                            <option value="">Select Branch</option>
                                            @if(old('company'))
                                                {{-- @foreach(BranchModel::where('company_id', old('company'))->get() as $data)
                                                <option value="{{ $data->id }}" {{ old('branch')==$data->id ? 'selected' : ''
                                                    }}>
                                                    {{ $data->name }}
                                                </option>
                                                @endforeach --}}
                                            @endif
                                        </select>
                                    </div>
                                    @error('branch')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="text-center">
                                    <button type="submit" class="btn bg-gradient-info w-100 mt-4 mb-0">Proceed</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="oblique position-absolute top-0 h-100 d-md-block d-none me-n8">
                        <div class="oblique-image bg-cover position-absolute fixed-top ms-auto h-100 z-index-0 ms-n6"
                            style="background-image:url('{{ getFileUrl($image->logo) }}')"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@push('scripts')

    <script>
        function loadBranches(companyId) {
            const branchSelect = document.getElementById('branch');
            branchSelect.innerHTML = '<option value="">Loading branches...</option>';

            if (!companyId) {
                branchSelect.innerHTML = '<option value="">Select Branch</option>';
                branchSelect.disabled = true;
                return;
            }

            fetch(`/setup/branches/${companyId}`)
                .then(response => response.json())
                .then(data => {
                    branchSelect.innerHTML = '<option value="">Select Branch</option>';

                    data.branches.forEach(branch => {
                        const option = document.createElement('option');
                        option.value = branch.id;
                        option.textContent = branch.name;
                        branchSelect.appendChild(option);
                    });

                    branchSelect.disabled = false;
                })
                .catch(error => {
                    branchSelect.innerHTML = '<option value="">Unable to loading branches</option>';
                    console.error('Error:', error);
                });
        }

        document.addEventListener('DOMContentLoaded', function () {
            const companyId = document.getElementById('company').value;
            if (companyId) {
                loadBranches(companyId);
            }
        });
    </script>
@endpush