<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ProductHistoryModel extends Model
{
    use HasFactory;
    protected $table = 'product_history';
    protected $primaryKey = 'id';
    protected $fillable = [
        'product_id',
        'branch_id',
        'name',
        'code',
        'category_id',
        'supplier_id',
        'unit_price',
        'qty',
        'description',
        'product_image',
        'action',
        'created_by',
    ];
    public function category()
    {
        return $this->belongsTo(CategoryModel::class);
    }
    public function user()
    {
        return $this->belongsTo(User::class, 'created_by');
    }
}
