<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class InvoiceModel extends Model
{
    use HasFactory;
    protected $table = 'invoices';
    public $timestamps = true;

    protected $primaryKey = 'id';
    protected $fillable = [
        'invoice_id',
        'client_id',
        'invoice_date',
        'due_date',
        'amount',
        'final_amount',
        'discount_type',
        'discount',
        'note',
        'term',
        'currency_id',
        'template_id',
        'payment_qr_code_id',
        'recurring',
        'recurring_cycle',
        'status',
        'parent_id',
        'branch_id',
        'gst',
        'oprntl_flag',
        'active_flag',
        'created_by',
        'updated_by',
    ];

    public function invoiceItems()
    {
        return $this->hasMany(InvoiceItemModel::class, 'invoice_id');
    }

    public function payments()
    {
        return $this->hasMany(PaymentsModel::class, 'invoice_id');
    }

    public function client()
    {
        return $this->belongsTo(ClientModel::class);
    }
    public function branch()
    {
        return $this->belongsTo(BranchModel::class, 'branch_id');
    }
    public function invoice_emi()
    {
        return $this->hasOne(InvoiceEmiModel::class, 'invoice_id', 'invoice_id');
    }
    public function discountType()
    {
        return $this->belongsTo(DiscountTypeModel::class, 'discount_type');
    }
    public function createdBy()
    {
        return $this->belongsTo(User::class, 'created_by');
    }
}