<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class InvoiceItemModel extends Model
{
    use HasFactory;
    protected $table = 'invoice_items';

    public $timestamps = true;

    protected $primaryKey = 'id';

    protected $fillable = [
        'invoice_id',
        'product_id',
        'quantity',
        'price',
        'margin_price',
        'total',
        'product_name'
    ];

    public function invoice()
    {
        return $this->belongsTo(InvoiceModel::class, 'invoice_id');
    }

    public function products()
    {
        return $this->belongsTo(ProductModel::class, 'product_id');
    }

    public function invoiceItemTaxes()
    {
        return $this->hasMany(InvoiceItemTaxModel::class, 'invoice_item_id');
    }
}