<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\CompanyModel;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class LoginController extends Controller
{
    public function showLoginForm()
    {
        if (auth()->user()) {
            return redirect('/dashboard');
        }

        $company = CompanyModel::first();

        return view('auth.login', [
            'company' => $company
        ]);
    }

    public function login(Request $request)
    {
        $credentials = $request->validate([
            'email' => 'required|email:rfc,dns',
            'password' => 'required',
        ]);

        $remember = $request->has('remember_me');

        if (Auth::attempt(['email' => $request->email, 'password' => $request->password], $remember)) {
            $user = User::where('email', $request->email)->first();
            Auth::login($user, $remember);

            return redirect()->intended('/setup');
        }

        return back()->withErrors([
            'email' => trans('auth.failed'),
        ])->withInput($request->only('email', 'remember_me'));
    }

    public function render()
    {
        return view('auth.login');
    }
}