<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\SupplierModel;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

class MobSupplierController extends Controller
{
public function allSuppliers(Request $request)
{
    Log::info("Called");
    $suppliers = SupplierModel::get(); 

    return response()->json([
        'data' => $suppliers,
        'total' => $suppliers->count(),
    ]);
}

public function index(Request $request)
{
    $query = SupplierModel::query();
    
    // Add search functionality
    if ($request->has('search')) {
        $search = $request->input('search');
        $query->where(function($q) use ($search) {
            $q->where('supplier_name', 'like', "%{$search}%")
              ->orWhere('phone', 'like', "%{$search}%")
              ->orWhere('email', 'like', "%{$search}%");
        });
    }
    
    // Paginate results
    $perPage = $request->input('per_page', 10);
    $suppliers = $query->paginate($perPage);
    
    return response()->json([
        'data' => $suppliers->items(),
        'current_page' => $suppliers->currentPage(),
        'last_page' => $suppliers->lastPage(),
        'total' => $suppliers->total(),
        'per_page' => $suppliers->perPage(),
    ]);
}
    public function store(Request $request)
    {
        $validated = $request->validate([
            'branch_id' => 'required|integer',
            'supplier_name' => 'required|string|max:255',
            'phone' => 'required|string|max:20',
            'email' => 'nullable|email|max:255',
            'address' => 'nullable|string',
            'active_status' => 'required|boolean',
        ]);

        $supplier = SupplierModel::create($validated);
        return response()->json(['data' => $supplier], 201);
    }

    public function update(Request $request, $id)
    {
        $supplier = SupplierModel::findOrFail($id);
        
        $validated = $request->validate([
            'branch_id' => 'required|integer',
            'supplier_name' => 'required|string|max:255',
            'phone' => 'required|string|max:20',
            'email' => 'nullable|email|max:255',
            'address' => 'nullable|string',
            'active_status' => 'required|boolean',
        ]);

        $supplier->update($validated);
        return response()->json(['data' => $supplier]);
    }

    public function destroy($id)
    {
        $supplier = SupplierModel::findOrFail($id);
        $supplier->delete();
        return response()->json(null, 204);
    }
}
