<?php


use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Log;
use NumberToWords\NumberToWords;



if (!function_exists("storeFile")) {
    function storeFile($file, $path)
    {
        // $subdomain = 'billing';
        $host = request()->getHost();
        $subdomain = explode('.', $host)[0];

        $fileName = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);
        $fileExtension = $file->getClientOriginalExtension();
        $uniqueFileName = $fileName . '_' . time() . '.' . $fileExtension;

        $filePath = $subdomain . '/' . $path . '/' . $uniqueFileName;

        if (Storage::disk('s3')->exists($filePath)) {
            return $filePath;
        }

        $filePath = $file->storeAs($subdomain . '/' . $path, $uniqueFileName, 's3');

        Storage::disk('s3')->setVisibility($filePath, 'public');

        return $filePath;
    }
}


if (!function_exists("getFileUrl")) {
    function getFileUrl($filePath)
    {
        $url = Storage::disk('s3')->url($filePath);
        return $url;
    }
}

function amountToWords($amount)
{
    $numberToWords = new NumberToWords();
    $numberTransformer = $numberToWords->getNumberTransformer('en'); // 'en' for English
    $integerPart = floor($amount);
    $decimalPart = round(($amount - $integerPart) * 100);

    $words = ucfirst($numberTransformer->toWords($integerPart)) . " rupees";
    if ($decimalPart > 0) {
        $words .= " and " . $numberTransformer->toWords($decimalPart) . " paise";
    }
    return $words;
}