<?php

use App\Http\Controllers\AdminController;
use App\Http\Controllers\LoginController;
use App\Http\Controllers\BranchController;
use App\Http\Controllers\CategoryController;
use App\Http\Controllers\ClientController;
use App\Http\Controllers\CompanyController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\ExpensesController;
use App\Http\Controllers\ImportController;
use App\Http\Controllers\InvoiceEmiController;
use App\Http\Controllers\InvoicePaymentController;
use App\Http\Controllers\ManufactureController;
use App\Http\Controllers\OrdersController;
use App\Http\Controllers\PDFController;
use App\Http\Controllers\PrivacyPolicyController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\ProductPaymentController;
use App\Http\Controllers\QuotesController;
use App\Http\Controllers\ReportController;
use App\Http\Controllers\InvoiceController;
use App\Http\Controllers\RightsController;
use App\Http\Controllers\SettingsController;
use App\Http\Controllers\SetupController;
use App\Http\Controllers\SuppliersController;
use App\Http\Controllers\TaxController;
use App\Http\Controllers\TemplateController;
use App\Http\Livewire\GeneratePdf;
use App\Http\Livewire\InvoiceEmi\AddInvoiceEmi;
use App\Http\Livewire\InvoiceEmi\InvoiceEmi;
use App\Http\Livewire\InvoiceEmiPayment;
use App\Http\Livewire\ProductPayments\ProductPayments;
use App\Http\Livewire\Setup;
use Illuminate\Support\Facades\Route;
use App\Http\Livewire\Auth\ForgotPassword;
use App\Http\Livewire\Auth\ResetPassword;
use App\Http\Livewire\Auth\SignUp;
use App\Http\Livewire\Auth\Login;
use App\Http\Livewire\Dashboard;
use App\Http\Livewire\Billing;
use App\Http\Livewire\Profile;
use App\Http\Livewire\Tables;
use App\Http\Livewire\StaticSignIn;
use App\Http\Livewire\StaticSignUp;
use App\Http\Livewire\Rtl;
use App\Http\Livewire\PaymentQR\PaymentQR;
use App\Http\Livewire\LaravelExamples\UserProfile;
use App\Http\Livewire\LaravelExamples\UserManagement;


/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return redirect('/login');
});

Route::get('/login', [LoginController::class, 'showLoginForm'])->name('login');
Route::post('/login', [LoginController::class, 'login']);

// Registration From
Route::get('/registration-form', [LoginController::class, 'registrationForm'])->name('registration-form');
Route::post('/registration-form-save', [LoginController::class, 'clientRegister'])->name('registration-form-save');

Route::get('/logout', function () {
    Auth::logout();
    return redirect()->route('login');
})->name('logout');

Route::middleware('auth')->group(function () {
    Route::get('/setup', [SetupController::class, 'index'])->name('setup');
    Route::get('/setup/branches/{id}', [SetupController::class, 'getBranches']);
    Route::post('/setup-submit', [SetupController::class, 'setup'])->name('setup-submit');
    Route::post('/switch-branch', [SetupController::class, 'switchBranch'])->name('switch-branch');
});

// Company
Route::get('/company/index', [CompanyController::class, 'index'])->name('company-index')->middleware('superUserCheck');
Route::get('/company/add', [CompanyController::class, 'create'])->name('company-add');
Route::post('/company/store', [CompanyController::class, 'store'])->name('company-store');
Route::get('/company/edit/{id}', [CompanyController::class, 'edit'])->name('company-edit');
Route::post('/company/update', [CompanyController::class, 'update'])->name('company-update');
Route::delete('/company/delete/{id}', [CompanyController::class, 'delete'])->name('company-delete');

// Branch
Route::get('/branch/index', [BranchController::class, 'index'])->name('branch-index')->middleware('superUserCheck');
Route::get('/branch/add', [BranchController::class, 'add'])->name('branch-add');
Route::post('/branch/store', [BranchController::class, 'store'])->name('branch-store');
Route::get('/branch/edit/{id}', [BranchController::class, 'edit'])->name('branch-edit');
Route::post('/branch/update', [BranchController::class, 'update'])->name('branch-update');
Route::delete('/branch/delete/{id}', [BranchController::class, 'delete'])->name('branch-delete');


Route::middleware(['auth', 'company.branch.setup'])->group(function () {

    // Categories
    Route::get('/category/index', [CategoryController::class, 'index'])->name('category-index');
    Route::get('/category/add', [CategoryController::class, 'add'])->name('category-add');
    Route::post('/category/store', [CategoryController::class, 'store'])->name('category-store');
    Route::get('/category/edit/{id}', [CategoryController::class, 'edit'])->name('category-edit');
    Route::post('/category/update', [CategoryController::class, 'update'])->name('category-update');
    Route::delete('/category/delete/{id}', [CategoryController::class, 'delete'])->name('category-delete');

    // Taxes
    Route::get('/taxes/index', [TaxController::class, 'index'])->name('tax-index');
    Route::get('/taxes/add', [TaxController::class, 'add'])->name('tax-add');
    Route::post('/taxes/store', [TaxController::class, 'store'])->name('tax-store');
    Route::get('/taxes/edit/{id}', [TaxController::class, 'edit'])->name('tax-edit');
    Route::post('/taxes/update', [TaxController::class, 'update'])->name('tax-update');
    Route::delete('/taxes/delete/{id}', [TaxController::class, 'delete'])->name('tax-delete');

    // rights
    Route::get('/rights/index', [RightsController::class, 'index'])->name('rights-index');
    Route::get('/rights/edit/{id}', [RightsController::class, 'edit'])->name('rights-edit');
    Route::post('/rights/update', [RightsController::class, 'store'])->name('rights-update');

    // Product
    Route::get('/products/index', [ProductController::class, 'index'])->name('product-index');
    Route::get('/products/add', [ProductController::class, 'add'])->name('product-add');
    Route::post('/products/store', [ProductController::class, 'store'])->name('product-store');
    Route::get('/products/edit/{id}', [ProductController::class, 'edit'])->name('product-edit');
    Route::post('/products/update', [ProductController::class, 'update'])->name('product-update');
    Route::get('/products/stock', [ProductController::class, 'purchase'])->name('product-stock');
    Route::post('/products/stock-save', [ProductController::class, 'savePurchase'])->name('product-stock-save');
    Route::delete('/products/delete/{id}', [ProductController::class, 'delete'])->name('product-delete');
    Route::post('/product-details-update', [ProductController::class, 'detailsUpdate'])->name('product-details-update');

    // invoice-payment-index
    Route::get('/invoice-payments/index', [InvoicePaymentController::class, 'index'])->name('invoice-payment-index');
    Route::get('/invoice-payments/add', [InvoicePaymentController::class, 'add'])->name('invoice-payment-add');
    Route::get('/invoice-payments/dtls/{id}', [InvoicePaymentController::class, 'getInvoiceDetails']);
    Route::post('/invoice-payments/store', [InvoicePaymentController::class, 'store'])->name('invoice-payment-store');
    Route::get('/invoice-payments/edit/{id}', [InvoicePaymentController::class, 'edit'])->name('invoice-payment-edit');
    Route::post('/invoice-payments/update', [InvoicePaymentController::class, 'update'])->name('invoice-payment-update');
    Route::delete('/invoice-payments/delete/{id}', [InvoicePaymentController::class, 'delete'])->name('invoice-payment-delete');

    //client
    Route::get('/clients/index', [ClientController::class, 'index'])->name('client-index');
    Route::get('/clients/add', [ClientController::class, 'add'])->name('client-add');
    Route::get('/getStates/{id}', [ClientController::class, 'getStates']);
    Route::get('/getCities/{id}', [ClientController::class, 'getCities']);
    Route::post('/clients/store', [ClientController::class, 'store'])->name('client-store');
    Route::get('/clients/edit/{id}', [ClientController::class, 'edit'])->name('client-edit');
    Route::post('/clients/update', [ClientController::class, 'update'])->name('client-update');
    Route::delete('/clients/delete/{id}', [ClientController::class, 'delete'])->name('client-delete');

    // Admin
    Route::get('/admins/index', [AdminController::class, 'index'])->name('admins-index');
    Route::get('/admins/add', [AdminController::class, 'add'])->name('admins-add');
    Route::post('/admins/store', [AdminController::class, 'store'])->name('admins-store');
    Route::get('/admins/edit/{id}', [AdminController::class, 'edit'])->name('admins-edit');
    Route::post('/admins/update', [AdminController::class, 'update'])->name('admins-update');
    Route::delete('/admins/delete/{id}', [AdminController::class, 'delete'])->name('admins-delete');

    // invoice
    Route::get('/invoice/index', [InvoiceController::class, 'index'])->name('invoice-index');
    Route::get('/invoice/add', [InvoiceController::class, 'add'])->name('invoice-add');
    Route::post('/invoice/store', [InvoiceController::class, 'store'])->name('invoice-store');
    Route::get('/invoice/edit/{id}', [InvoiceController::class, 'edit'])->name('invoice-edit');
    Route::post('/invoice/update', [InvoiceController::class, 'update'])->name('invoice-update');
    Route::delete('/invoice/delete/{id}', [InvoiceController::class, 'delete'])->name('invoice-delete');
    Route::get('get-single-client-details', [InvoiceController::class, 'getSingleClient'])->name('single-client');
    Route::get('get-invoice-client-details', [InvoiceController::class, 'getInvoiceClient'])->name('invoice-client');
    Route::post('/invoice-updateDeliveryStatus', [InvoiceController::class, 'updateDeliveryStatus'])->name('invoice-updateDeliveryStatus');
    // Invoice Delivery Status
    Route::post('/show-df', [PDFController::class, 'generateInvoice'])->name('show-pdf');
    Route::get('/invoice/pdf/{id}', [PDFController::class, 'generatePdf'])->name('pdf');

    // quotes 
    Route::get('/quotes/index', [QuotesController::class, 'index'])->name('quotes-index');
    Route::get('/quotes/add', [QuotesController::class, 'add'])->name('quotes-add');
    Route::post('/quotes/store', [QuotesController::class, 'store'])->name('quotes-store');
    Route::get('/quotes/edit/{id}/{type}', [QuotesController::class, 'edit'])->name('quotes-edit');
    Route::post('/quotes/update', [QuotesController::class, 'update'])->name('quotes-update');
    Route::delete('/quotes/delete/{id}', [QuotesController::class, 'delete'])->name('quotes-delete');
    // Quotes pdf
    Route::get('/quote-pdf/{id}', [PDFController::class, 'openQoutePdfPage'])->name('quote-pdf');
    Route::post('/show-quote-pdf', [PDFController::class, 'generateQuote'])->name('show-quote-pdf');

    // Client Address
    Route::get('/get-client-address/{phone}', [QuotesController::class, 'getClientAddress']);
    Route::post('/store-client-address', [QuotesController::class, 'storeClientAddress']);
    Route::get('/remove-client-address', [QuotesController::class, 'removeClientAddress']);

    // Orders 
    Route::get('/orders/index', [OrdersController::class, 'index'])->name('orders-index');
    Route::get('/orders/add', [OrdersController::class, 'add'])->name('orders-add');
    Route::post('/orders/store', [OrdersController::class, 'store'])->name('orders-store');
    Route::get('/orders/edit/{id}/{type}', [OrdersController::class, 'edit'])->name('orders-edit');
    Route::post('/orders/update', [OrdersController::class, 'update'])->name('orders-update');
    Route::delete('/orders/delete/{id}', [OrdersController::class, 'delete'])->name('orders-delete');
    // Order PDF
    Route::get('/order-pdf/{id}', [PDFController::class, 'openOrderPdfPage'])->name('order-pdf');
    Route::post('/show-order-pdf', [PDFController::class, 'generateOrder'])->name('show-order-pdf');


    // supplier
    Route::get('/supplier/index', [SuppliersController::class, 'index'])->name('supplier-index');
    Route::get('/supplier/add', [SuppliersController::class, 'add'])->name('supplier-add');
    Route::post('/supplier/store', [SuppliersController::class, 'store'])->name('supplier-store');
    Route::get('/supplier/edit/{id}', [SuppliersController::class, 'edit'])->name('supplier-edit');
    Route::post('/supplier/update', [SuppliersController::class, 'update'])->name('supplier-update');
    Route::delete('/supplier/delete{id}', [SuppliersController::class, 'delete'])->name('supplier-delete');

    // expense
    Route::get('/expense/index', [ExpensesController::class, 'index'])->name('expense-index')->middleware('admin');
    Route::get('/expense/add', [ExpensesController::class, 'add'])->name('expense-add');
    Route::post('/expense/store', [ExpensesController::class, 'store'])->name('expense-store');
    Route::get('/expense/edit/{id}', [ExpensesController::class, 'edit'])->name('expense-edit');
    Route::post('/expense/update', [ExpensesController::class, 'update'])->name('expense-update');
    Route::delete('/expense/delete/{id}', [ExpensesController::class, 'delete'])->name('expense-delete');

    // product-payment
    Route::get('/product-payments/index', [ProductPaymentController::class, 'index'])->name('product-payment-index');
    Route::get('/product-payments/add', [ProductPaymentController::class, 'add'])->name('product-payment-add');
    Route::get('/product-payments/get-product-details/{id}', [ProductPaymentController::class, 'getProductDetails']);
    Route::post('/product-payments/store', [ProductPaymentController::class, 'store'])->name('product-payment-store');
    Route::get('/product-payments/edit/{id}', [ProductPaymentController::class, 'edit'])->name('product-payment-edit');
    Route::post('/product-payments/update', [ProductPaymentController::class, 'update'])->name('product-payment-update');
    Route::delete('/product-payments/delete/{id}', [ProductPaymentController::class, 'delete'])->name('product-payment-delete');

    // Invoice-EMI
    Route::get('/invoice-emi/index', [InvoiceEmiController::class, 'index'])->name('invoice-emi-index');
    Route::get('/invoice-emi/add', [InvoiceEmiController::class, 'add'])->name('invoice-emi-add');
    Route::post('/invoice-emi/store', [InvoiceEmiController::class, 'store'])->name('invoice-emi-store');
    Route::get('/invoice-emi/edit/{id}', [InvoiceEmiController::class, 'edit'])->name('invoice-emi-edit');
    Route::get('/invoice-emi/payment/{id}', [InvoiceEmiController::class, 'payment'])->name('invoice-emi-payment');
    Route::post('/invoice-emi/store-payment', [InvoiceEmiController::class, 'savePayment'])->name('invoice-emi-store-payment');
    Route::post('/invoice-emi/pre-closure', [InvoiceEmiController::class, 'preClosure'])->name('invoice-emi-pre-closure');
    Route::post('/invoice-emi/update', [InvoiceEmiController::class, 'update'])->name('invoice-emi-update');
    Route::delete('/invoice-emi/delete/{id}', [InvoiceEmiController::class, 'delete'])->name('invoice-emi-delete');

    // Manufacture
    Route::get('/manufacture-index', [ManufactureController::class, 'index'])->name('manufacture-index');

    // Bill Of Material
    Route::get('/manufacture-bom-add', [ManufactureController::class, 'bomAdd'])->name('manufacture-bom-add');
    Route::get('/manufacture-bom-edit/{id}', [ManufactureController::class, 'bomEdit'])->name('manufacture-bom-edit');
    Route::post('/manufacture-bom-store', [ManufactureController::class, 'bomStore'])->name('manufacture-bom-store');
    Route::post('/manufacture-bom-update/{id}', [ManufactureController::class, 'bomUpdate'])->name('manufacture-bom-update');
    Route::get('/manufacture-bom-delete/{id}', [ManufactureController::class, 'bomDelete'])->name('manufacture-bom-delete');

    // Assembled Items
    Route::get('/manufacture-assemble-add', [ManufactureController::class, 'assembleAdd'])->name('manufacture-assemble-add');
    Route::get('/manufacture-assemble-view/{id}', [ManufactureController::class, 'assembleEdit'])->name('manufacture-assemble-view');
    Route::post('/manufacture-assemble-store', [ManufactureController::class, 'assembleStore'])->name('manufacture-assemble-store');
    Route::post('/manufacture-assemble-update/{id}', [ManufactureController::class, 'assembleUpdate'])->name('manufacture-assemble-update');
    Route::get('/manufacture-assemble-delete/{id}', [ManufactureController::class, 'assembleDelete'])->name('manufacture-assemble-delete');
    Route::post('/save-costType', [ManufactureController::class, 'saveCostType'])->name('save-costType');

    Route::get('/get-products', [ManufactureController::class, 'getProducts'])->name('get-products');

    // Dashboard
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');

    // Reports
    Route::get('/product_report', [ReportController::class, 'productFilter'])->name('product-Report')->middleware('admin');
    Route::get('/profit_report', [ReportController::class, 'profitFilter'])->name('profit_report')->middleware('admin');
    Route::get('/emi_profit_report', [ReportController::class, 'emiProfitFilter'])->name('emi_profit_report')->middleware('admin');
    Route::get('/invoice_report', [ReportController::class, 'invoiceFilter'])->name('invoice-Report')->middleware('admin');
    Route::get('/invoice_emi_report', [ReportController::class, 'invoiceEmiFilter'])->name('invoice-emi-Report')->middleware('admin');
    Route::get('/invoice_emi_profit', [ReportController::class, 'emiProfit'])->name('invoice_emi_profit')->middleware('admin');
    Route::get('/get-invoice-details/{id}', [ReportController::class, 'getInvoiceDetails']);
    Route::get('/product-purchase', [ReportController::class, 'productPurchase'])->name('product-purchase')->middleware('admin');
    Route::get('/inventory-report', [ReportController::class, 'inventoryReport'])->name('inventory-report')->middleware('admin');
    Route::get('/gst-report', [ReportController::class, 'gstReport'])->name('gst-report')->middleware('admin');
    Route::get('/hsn-report', [ReportController::class, 'hsnReport'])->name('hsn-report')->middleware('admin');
    Route::get('/expense-report', [ReportController::class, 'expenseReport'])->name('expense-report')->middleware('admin');

    Route::post('/save-invoice-pdf', [InvoiceController::class, 'savePdf'])->name('invoice.save');

});

Route::post('/send-invoice', [InvoiceController::class, 'sendInvoice'])->name('send.invoice');
Route::get('/settings', [SettingsController::class, 'show'])->name('settings');
Route::post('/settings_save', [SettingsController::class, 'save'])->name('settings_save');

//import page 
Route::get('/product-import-index', [ImportController::class, 'productIndex'])->name('product-import-index');
Route::get('/categories-import-index', [ImportController::class, 'categoriesIndex'])->name('categories-import-index');
Route::get('/supplier-import-index', [ImportController::class, 'supplierIndex'])->name('supplier-import-index');
Route::get('/client-import-index', [ImportController::class, 'clientIndex'])->name('client-import-index');
Route::get('/tax-import-index', [ImportController::class, 'taxIndex'])->name('tax-import-index');

// Import
Route::post('/product-import', [ImportController::class, 'productImport'])->name('product-import');
Route::post('/categories-import', [ImportController::class, 'categoriesImport'])->name('categories-import');
Route::post('/supplier-import', [ImportController::class, 'supplierImport'])->name('supplier-import');
Route::post('/client-import', [ImportController::class, 'clientImport'])->name('client-import');
Route::post('/tax-import', [ImportController::class, 'taxImport'])->name('tax-import');

// Template
Route::get('/product-template', [TemplateController::class, 'productTemplate'])->name('product-template');
Route::get('/categories-template', [TemplateController::class, 'categoriesTemplate'])->name('categories-template');
Route::get('/supplier-template', [TemplateController::class, 'supplierTemplate'])->name('supplier-template');
Route::get('/client-template', [TemplateController::class, 'clientTemplate'])->name('client-template');
Route::get('/tax-template', [TemplateController::class, 'taxTemplate'])->name('tax-template');

// Privacy Policy
Route::get('/privacy-policy', [PrivacyPolicyController::class, 'index'])->name('privacy-policy');
