@extends('layouts.layoutapp')
@section('content')
    <div class="main-content">
        <div class="row">
            <div class="col-12">
                <div class="card mb-4 mx-4">
                    <div class="card-header pb-0">
                        <div class="d-flex justify-content-between">
                            <h5 class="mb-0">Update Supplier</h5>
                        </div>
                    </div>

                    <div class="card-body">
                        <form action="{{ route('supplier-update') }}" method="POST">
                            @csrf
                           <input type="hidden" name="id" id="id" value="{{$supplier->id}}">
                            <div class="row">
                                <div class="col-lg-4 mb-4">
                                    <label for="name" class="form-label">Supplier Name:</label>
                                    <input type="text" id="name" name="name" class="form-control"
                                        value="{{ old('name', $supplier->supplier_name) }}"
                                        placeholder="Enter supplier name"  required>
                                    @error('name') <span class="text-danger">{{ $message }}</span> @enderror
                                </div>
                                <div class="col-lg-4 mb-4">
                                    <label for="phone_Number" class="form-label">Phone Number:</label>
                                    <input type="number" id="phone_Number" name="phone_Number" class="form-control"
                                        value="{{ old('phone_Number', $supplier->phone) }}"  placeholder="Enter phone number"
                                        required>
                                    @error('phone_Number') <span class="text-danger">{{ $message }}</span> @enderror
                                </div>
                                <div class="col-lg-4 mb-4">
                                    <label for="email" class="form-label">Email Address:</label>
                                    <input type="email" id="email" name="email" class="form-control"
                                        value="{{ old('email', $supplier->email) }}"
                                        placeholder="Enter email address">
                                    @error('email') <span class="text-danger">{{ $message }}</span> @enderror
                                </div>
                                <div class="col-lg-4 mb-4">
                                    <label for="address" class="form-label">Physical Address:</label>
                                    <input type="text" id="address" name="address" class="form-control"
                                        value="{{ old('address', $supplier->address) }}"
                                        placeholder="Enter supplier address">
                                    @error('address') <span class="text-danger">{{ $message }}</span> @enderror
                                </div>
                                <div class="col-lg-4 mb-4">
                                    <label for="isActive" class="form-label">Account Status:</label>
                                    <div class="d-flex">
                                        <div class="form-check form-check-inline">
                                            <input type="radio" id="isActiveYes" class="form-check-input" name="isActive"
                                                value="1" {{ old('isActive', $supplier->active_status) == 1 ? 'checked' : '' }} required>
                                            <label for="isActiveYes" class="form-check-label">Active</label>
                                        </div>
                                        <div class="form-check form-check-inline">
                                            <input type="radio" id="isActiveNo" class="form-check-input" name="isActive"
                                                value="0" {{ old('isActive', $supplier->active_status) == 0 ? 'checked' : '' }} required>
                                            <label for="isActiveNo" class="form-check-label">Inactive</label>
                                        </div>
                                    </div>
                                    @error('isActive') <span class="text-danger">{{ $message }}</span> @enderror
                                </div>
                            </div>
                            <div class="d-flex justify-content-end gap-2">
                                <button type="submit" class="btn btn-primary">Update Supplier</button>
                                <a href="{{ route('supplier-index') }}" class="btn btn-secondary">Cancel</a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection