@extends('layouts.layoutapp')

@section('content')
    <div class="main-content">
        <div class="row">
            <div class="col-12">
                <div class="card mb-4 mx-4">
                    <div class="card-header pb-0">
                        <div class="d-flex flex-row justify-content-between">
                            <div>
                                <h5 class="mb-0">All Quotes</h5>
                            </div>
                            <a href="{{ route('quotes-add') }}" class="btn bg-gradient-primary btn-sm mb-0">+&nbsp; Add
                                Quotes</a>
                        </div>
                    </div>

                    <div class="card-body px-0 pt-0 pb-2">
                        <div class="table-responsive p-0">
                            <table class="table align-items-center mb-0" id="myTable">
                                <thead>
                                    <tr>
                                        <th
                                            class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                            Quotes Id</th>
                                        <th
                                            class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                            Client</th>
                                        <th
                                            class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                            Quote Date</th>
                                        <th
                                            class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                            Due Date</th>
                                        <th
                                            class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                            Amount</th>
                                        <th
                                            class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                            Status</th>
                                        <th
                                            class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                            Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach     ($quotes as $quote)
                                        <tr>
                                            <td class="ps-4 text-center">
                                                <p class="text-xs text-center font-weight-bold mb-0">{{ $quote->quote_id ?? 'Quotes' }}</p>
                                            </td>
                                             <td class="ps-4 text-center">
                                                <p class="text-xs text-center font-weight-bold mb-0">{{ $quote->client->user->name ?? '' }}</p>
                                            </td>
                                            <td class="ps-4 text-center">
                                                <p class="text-xs text-center font-weight-bold mb-0">{{ $quote->quote_date ? \Carbon\Carbon::parse($quote->quote_date)->format('d-m-Y') : '' }}</p>
                                            </td>
                                            <td class="text-center">
                                                <p class="text-xs text-center font-weight-bold mb-0">{{ $quote->due_date ? \Carbon\Carbon::parse($quote->due_date)->format('d-m-Y') : '' }}</p>
                                            </td>
                                            <td class="text-center">
                                                <p class="text-xs text-center font-weight-bold mb-0">{{ $quote->final_amount }}</p>
                                            </td>
                                            <td class="text-center">
                                                <p class="text-xs text-center font-weight-bold mb-0">
                                                    @if($quote->status == 1)
                                                        <span class="badge bg-info">Draft</span>
                                                        @elseif($quote->status == 2)
                                                        <span class="badge bg-warning">Partially Completed</span>
                                                        @elseif($quote->status == 3)
                                                        <span class="badge bg-success">Completed</span>
                                                    @endif
                                                </p>

                                            </td>
                                            <td class="text-center">
                                                <div class="d-flex justify-content-center align-items-center gap-3">
                                                    <!-- Edit Quote -->
                                                    <a href="{{ route('quotes-edit', ['id' => $quote->id, 'type' => 'edit']) }}"
                                                        @if($quote->oprntl_flag == 'C')
                                                            style="pointer-events: none; opacity: 0.5;"
                                                        title="Edit Quote (Disabled)" @endif>
                                                        <i class="fa-solid fa-pen-to-square text-secondary fa-lg ms-2"
                                                            title="Edit Quote"></i>
                                                    </a>

                                                    <!-- Convert Quote -->
                                                    <a
                                                        href="{{ route('quotes-edit', ['id' => $quote->id, 'type' => 'convert']) }}">
                                                        <i class="fa-solid fa-money-bill-transfer text-secondary fa-lg ms-2"
                                                            title="Convert Quote"></i>
                                                    </a>

                                                    <!-- Download Invoice -->
                                                    <a href="{{ route('quote-pdf', $quote->id) }}">
                                                        <i class="fa-solid fa-download text-secondary ms-2"
                                                            title="Download Invoice"></i>
                                                    </a>

                                                    <!-- Delete Quote -->
                                                    <span class="ms-2">
                                                        <form action="{{ route('quotes-delete', $quote->id) }}" method="POST"
                                                            class="d-inline" id="delete-form-{{$quote->id}}">
                                                            @csrf
                                                            @method('DELETE')
                                                            <i class="fas fa-trash text-secondary fa-lg"
                                                                @if($quote->oprntl_flag == 'C')
                                                                    style="pointer-events: none; opacity: 0.5;"
                                                                    title="Delete Quote (Disabled)" @else title="Delete Quote"
                                                                onclick="confirmDelete({{ $quote->id }})" @endif>
                                                            </i>
                                                        </form>
                                                    </span>
                                                </div>
                                            </td>
                                        </tr>                                  
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@push('scripts')
    <script>
        function confirmDelete(id) {
            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Yes, delete it!',
                cancelButtonText: 'Cancel'
            }).then((result) => {
                if (result.isConfirmed) {
                    document.getElementById('delete-form-' + id).submit();
                }
            });
        }
    </script>
@endpush