<!DOCTYPE html>
<html lang="en">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    {{--
    <link rel="stylesheet" href="{{asset('assets/css/style.css')}}">
    <link rel="stylesheet" href="{{asset('assets/css/bootstrap.min.css')}}">
    <link rel="stylesheet" href="{{asset('assets/css/soft-ui-dashboard.css')}}">
    <link rel="stylesheet" href="{{asset('assets/css/soft-ui-dashboard.min.css')}}">
    <link rel="stylesheet" href="{{asset('assets/css/soft-ui-dashboard.css.map')}}">
    <link rel="stylesheet" href="{{asset('assets/css/nucleo-svg.css')}}"> --}}
    <title>Invoice</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
        }

        .header {
            width: 100%;
            margin-bottom: 0px;
            border-top: 1px solid #000;
            border-left: 1px solid #000;
            border-right: 1px solid #000;
        }

        .company-details {
            text-align: center;
        }

        .address {
            text-align: center;
            font-size: 18px;
            font-weight: bold;
        }

        .mail {
            text-align: center;
            font-size: 18px;
            font-weight: bold;
        }

        .invoice-details {
            width: 100%;
            margin-bottom: 0px;
            margin-top: 0px;
        }

        .info-table {
            width: 100%;
            border-top: 1px solid #000;
            border-left: 1px solid #000;
            border-right: 1px solid #000;
            border-collapse: collapse;
            /* table-layout: fixed; */
        }

        .info-table td {
            width: 50%;
            padding: 8px;
            vertical-align: top;
            border-right: 1px solid #000;
        }

        .client-details {
            text-align: left;
        }

        .invoice-info {
            text-align: left;
        }

        .product-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 0px;
        }

        .product-table th,
        .product-table td {
            border-left: 1px solid #000;
            border-right: 1px solid #000;
            border-bottom: 1px solid #000;
            padding: 3px;
            text-align: left;
        }

        .product-table tbody tr:last-child td {
            border-bottom: 1px solid #000;
        }

        .product-table th {
            background-color: #f2f2f2;
            border-top: 1px solid #000;
            border-bottom: 1px solid #000;
        }

        .footer {
            border-bottom: 1px solid #000;
            border-left: 1px solid #000;
            border-right: 1px solid #000;
            text-align: right;
            padding-right: 10px;
            width: 10s0%;
        }

        .col-id {
            width: 80px;
        }

        .col-description {
            width: 40%;
        }

        .col-code {
            width: 80px;
        }

        .col-qty {
            width: 80px;
        }

        .col-rate {
            width: 80px;
        }

        .col-gst {
            width: 80px;
        }

        .col-total {
            width: 90px;
        }

        .page-break {
            page-break-before: always;
        }

        .invoice-btn-section .row {
            display: flex;
            flex-wrap: nowrap;
            align-items: center;
        }

        .invoice-btn-section .btn {
            white-space: nowrap;
            margin: 0 5px;
        }

        .invoice-btn-section .form-select {
            min-width: 200px;
        }

        @media (max-width: 768px) {
            .invoice-btn-section .row {
                flex-wrap: wrap;
            }

            .invoice-btn-section .col-md-auto,
            .invoice-btn-section .col-md-3 {
                width: 100%;
                margin-bottom: 10px;
            }
        }
    </style>
</head>

<body>
    <div class="invoice-1 invoice-content">
        <div class="container">
            <div id="invoice_wrapper">
                <div class="header">
                    <div class="company-details">
                        <h3>{{$addedInvoice->branch->company->name}}</h3>
                    </div>
                    <div class="address">
                        {{$addedInvoice->branch->company->address}},
                    </div>
                    <div class="mail">
                        Mail -{{$addedInvoice->branch->company->email}}

                    </div>
                </div>
                <div class="invoice-details">
                    <table class="info-table">
                        <tr>
                            <td class="client-details text-start">
                                <strong>GST No -</strong>
                                {{$addedInvoice->branch->gst_no ?? ''}}<br>
                            </td>
                            <td class="invoice-info">
                                <strong>Contact No:</strong> {{ $addedInvoice->branch->company->phone ?? ''}}<br>
                            </td>
                        </tr>
                    </table>
                </div>
                <div class="invoice-details">
                    <table class="info-table">
                        <tr>
                            <td class="client-details text-start">
                                <strong>To:</strong>
                                {{$addedInvoice->client->user->name ?? ''}}<br>
                                <strong>Address:</strong>
                                @php
                                    $address = optional(optional($addedInvoice->order)->clientAddress)->address
        ?? optional(optional($addedInvoice->client)->user)->location
        ?? '';
                                @endphp
                                {{$address ?? ''}}
                            </td>
                            <td class="invoice-info">
                                <strong>
                                    Payment Terms: </strong>
                                @if($addedInvoice->payments->isNotEmpty())
                                    @foreach($addedInvoice->payments as $payment)
                                        @if($payment->mode)
                                            {{ $payment->mode->name }}
                                        @else
                                            N/A<br>
                                        @endif
                                    @endforeach
                                @else
                                    N/A
                                @endif <br>
                                <strong>Bill No:</strong>
                                {{ $addedInvoice->invoice_id ?? ''}}
                                <br>
                                <strong>Date:</strong>
                                {{ $addedInvoice->invoice_date ? \Carbon\Carbon::parse($addedInvoice->invoice_date)->format('d-m-Y') : '' }}
                            </td>
                        </tr>
                    </table>
                </div>
                <table class="product-table">
                    <thead>
                        <tr>
                            <th class="col-id">S.No</th>
                            <th class="col-description">Description</th>
                            <th class="col-code">HSN Code</th>
                            <th class="col-qty">C.Qty</th>
                            <th class="col-qty">Qty</th>
                            <th class="col-rate">Rate</th>
                            <th class="col-gst">GST(%)</th>
                            <th class="col-total">Total</th>
                        </tr>
                    </thead>
                    <tbody>
                        @php
                            $subtotal = 0;
                            $pageSubtotal = 0;
                            $pageCount = 0;               
                        @endphp
                        @foreach ($addedInvoice->invoiceItems as $index => $product)

                            @php                            
                                $orderItem = isset($addedInvoice->order) ? $addedInvoice->order->ordersItem->firstWhere('product_id', $product->product_id):$addedInvoice->quote->quotesItem->firstWhere('product_id', $product->product_id);
                                $total = $product->quantity * $product->price;                                
                                $gstAmount = ($product->total * $product->invoiceItemTaxes->sum('tax')) / 100;
                                $totalWithGst = $total + $gstAmount;
                                $subtotal += $totalWithGst;
                                $pageSubtotal += $totalWithGst;                                                                
                            @endphp
                            <tr>
                                <td class="col-id">{{ $index + 1 }}</td>
                                <td class="col-description">{{$settings->native_name_flag=='A'? ($addedInvoice->products->native_name ?? $addedInvoice->product_name ):($addedInvoice->product_name ?? '') }}</td>
                                <td class="col-code">
                                    {{ $product->products->code}}
                                </td>
                                <td class="col-qty">
                                    @if ($orderItem)
                                        {{ $orderItem->quantity . ' (' . optional($orderItem->product->category->unitOfMass)->name . ')' }}
                                    @else
                                        <span class="text-muted">Not in Order</span>
                                    @endif
                                </td>
                                <td class="col-qty">
                                    {{ $product->quantity . '(' . ($product->products->category->unitOfMass->name ?? '') . ')' ?? '' }}
                                </td>
                                <td class="col-rate">₹ {{ number_format($product->price ?? '', 2) }}</td>
                                <td class="col-gst">
                                    {{ number_format($product->invoiceItemTaxes->sum('tax') ?: 0, 2) }}
                                </td>
                                <td class="col-total">@php
                                    $gstAmount = ($product->total * $product->invoiceItemTaxes->sum('tax')) / 100;
                                    $total = $product->total + $gstAmount;
                                @endphp
                                    ₹ {{ number_format($total, 2) }}
                                </td>
                            </tr>

                            @if (($index + 1) % 25 == 0)
                                    </tbody>
                                </table>
                                <div class="footer">
                                    <table class="footer-table" style="width: 100%; border-collapse: collapse;">
                                        <tr class="text-start">
                                            <td style="text-align: left;"><strong>Subtotal:</strong> </td>
                                            <td style="text-align: right;">₹ {{ number_format($pageSubtotal, 2) }}</td>
                                        </tr>
                                        <tr class="text-start">
                                            <td style="text-align: left;"><strong>Previous Page Subtotal:</strong></td>
                                            <td style="text-align: right;">₹
                                                {{ number_format($subtotal - $pageSubtotal, 2) }}
                                            </td>
                                        </tr>
                                        <tr class="text-start">
                                            <td style="text-align: left;"><strong>Total:</strong></td>
                                            <td style="text-align: right;">₹ {{ number_format($subtotal, 2) }}</td>
                                        </tr>
                                    </table>
                                </div>
                                <p style="text-align: right; margin-bottom: 30px;">...Continue</p>
                                <div class="page-break"></div>
                                <div class="header">
                                    <div class="company-details">
                                        <h3>{{$addedInvoice->branch->company->name}}</h3>
                                    </div>
                                    <div class="address">
                                        {{$addedInvoice->branch->company->address}},
                                    </div>
                                    <div class="mail">
                                        Mail -{{$addedInvoice->branch->company->email}}
                                    </div>
                                </div>
                                <div class="invoice-details">
                                    <table class="info-table">
                                        <tr>
                                            <td class="client-details text-start">
                                                <strong>GST No -</strong>
                                                {{$addedInvoice->branch->gst_no ?? ''}}<br>
                                            </td>
                                            <td class="invoice-info">
                                                <strong>Contact No:</strong> {{ $addedInvoice->branch->company->phone ?? ''}}<br>
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                                <div class="invoice-details">
                                    <table class="info-table">
                                        <tr>
                                            <td class="client-details text-start">
                                                <strong>To:</strong>
                                                {{$addedInvoice->client->user->name ?? ''}}<br>
                                                <strong>Address:</strong>
                                                 {{$address ?? ''}}
                                            </td>
                                            <td class="invoice-info">
                                                <strong>Payment Terms:</strong>
                                                {{$addedInvoice->due_date ? \Carbon\Carbon::parse($addedInvoice->due_date)->format('d-m-Y') : ''}}<br>
                                                <strong>Bill No:</strong>
                                                {{ $addedInvoice->invoice_id ?? ''}}
                                                <br>
                                                <strong>Date:</strong>
                                                {{ $addedInvoice->invoice_date ? \Carbon\Carbon::parse($addedInvoice->invoice_date)->format('d-m-Y') : '' }}
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                                <table class="product-table">
                                    <thead>
                                        <tr>
                                            <th class="col-id">S.No</th>
                                            <th class="col-description">Description</th>
                                            <th class="col-code">HSN Code</th>
                                            <th class="col-qty">C.Qty</th>
                                            <th class="col-qty">Qty</th>
                                            <th class="col-rate">Rate</th>
                                            <th class="col-gst">GST(%)</th>
                                            <th class="col-total">Total</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @php
                                            $pageSubtotal = 0;
                                            $pageCount++;
                                        @endphp
                            @endif

                        @endforeach </tbody>
                </table>
                <div class="footer">
                    <table class="footer-table" style="width: 100%; border-collapse: collapse;">
                        <tr>
                            <td style="text-align:left"> <strong>Subtotal:</strong></td>
                            <td style="text-align:right;">₹ {{ number_format($pageSubtotal, 2) }}</td>
                        </tr>
                        <tr>
                            <td style="text-align:left"> <strong>Previous Page Subtotal:</strong></td>
                            <td style="text-align:right;">₹
                                {{ number_format($subtotal - $pageSubtotal, 2) }}
                            </td>
                        </tr>
                        <tr>
                            <td style="text-align:left"> <strong>Total:</strong></td>
                            <td style="text-align:right;">₹ {{ number_format($subtotal, 2) }}</td>
                        </tr>
                        <tr>
                            @php if ($addedInvoice->discount_type == 1) {
                            $discount = $addedInvoice->discount;
                            } elseif ($addedInvoice->discount_type == 2) {
                            $discountAmount = ($subtotal * $addedInvoice->discount)
                            / 100;
                            $discount = $discountAmount;
                            } else {
                            $discount = 0;
                            }
                            @endphp
                            <td style="text-align:left"> <strong>Discount:</strong></td>
                            <td style="text-align:right;">₹ {{ number_format($discount, 2) }}</td>
                        </tr>
                        @if($settings->loyalty_config == 'A')
                            <tr>
                                <td style="text-align:left"> <strong>Redeemed Amount:</strong></td>
                                <td style="text-align:right;">₹ {{ $redeemed_value ?? '' }}</td>
                            </tr>
                        @endif
                        <tr>
                            <td style="text-align:left"> <strong>GrandTotal:</strong></td>
                            <td style="text-align:right;">₹
                                {{ number_format(floor(($subtotal - $discount) - ($settings->loyalty_config == 'A' ? $redeemed_value : 0)), 2) }}
                            </td>
                        </tr>
                        <tr>
                            <td style="text-align:left"><strong>Total Purchased Product Qty </strong></td>
                            <td style="text-align:right;">
                                @php
                                    $sumQty = 0;
                                    foreach ($addedInvoice->invoiceItems as $item) {
                                        $sumQty += $item->quantity;
                                    }                      
                                @endphp
                                {{$sumQty ?? 0}}
                            </td>
                        </tr>
                        <tr>
                            <td style="text-align:left" colspan="2"> <strong>Amount In words:</strong>
                                {{ amountToWords(round(floor($subtotal - $discount),2)) }}</td>

                        </tr>
                        @if (isset($settings->declaration))
                            <tr>
                                <td style="text-align:left" colspan="2"> <strong>Terms & Conditions:</strong>
                                    {{isset($settings->declaration) ? $settings->declaration : ''}}
                                </td>
                            </tr>
                        @endif
                    </table>
                </div>
            </div>

        </div>
    </div>


</body>

</html>