<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>Quotes</title>  
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
        }

        .header {
            width: 100%;
            margin-bottom: 0px;
            border-top: 1px solid #000;
            border-left: 1px solid #000;
            border-right: 1px solid #000;
        }

        .company-details {
            text-align: center;
        }

        .address {
            text-align: center;
            font-size: 18px;
            font-weight: bold;
        }

        .mail {
            text-align: center;
            font-size: 18px;
            font-weight: bold;
        }

        .invoice-details {
            width: 100%;
            margin-bottom: 0px;
            margin-top: 0px;
        }

        .info-table {
            width: 100%;
            border-top: 1px solid #000;
            border-left: 1px solid #000;
            border-right: 1px solid #000;
            border-collapse: collapse;
          
        }

        .info-table td {
            width: 50%;
            padding: 8px;
            vertical-align: top;
            border-right: 1px solid #000;
        }

        .client-details {
            text-align: left;
        }

        .invoice-info {
            text-align: left;
        }

        .product-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 0px;
        }

        .product-table th,
        .product-table td {
            border-left: 1px solid #000;
            border-right: 1px solid #000;
            border-bottom: 1px solid #000;
            padding: 3px;
            text-align: left;
        }

        .product-table tbody tr:last-child td {
            border-bottom: 1px solid #000;
        }

        .product-table th {
            background-color: #f2f2f2;
            border-top: 1px solid #000;
            border-bottom: 1px solid #000;
        }

        .footer {
            border-bottom: 1px solid #000;
            border-left: 1px solid #000;
            border-right: 1px solid #000;
            text-align: right;
            padding-right: 10px;
            width: 10s0%;
        }

        .col-id {
            width: 80px;
        }

        .col-description {
            width: 40%;
        }

        .col-code {
            width: 80px;
        }

        .col-qty {
            width: 80px;
        }

        .col-rate {
            width: 80px;
        }

        .col-gst {
            width: 80px;
        }

        .col-total {
            width: 90px;
        }

        .page-break {
            page-break-before: always;
        }

        .invoice-btn-section .row {
            display: flex;
            flex-wrap: nowrap;
            align-items: center;
        }

        .invoice-btn-section .btn {
            white-space: nowrap;
            margin: 0 5px;
        }

        .invoice-btn-section .form-select {
            min-width: 200px;
        }

        @media (max-width: 768px) {
            .invoice-btn-section .row {
                flex-wrap: wrap;
            }

            .invoice-btn-section .col-md-auto,
            .invoice-btn-section .col-md-3 {
                width: 100%;
                margin-bottom: 10px;
            }
        }
    </style>
</head>

<body>
    <div class="invoice-1 invoice-content">
        <div class="container">
            <div id="invoice_wrapper">
                <div class="header">
                    <div class="company-details">
                        <h3>{{$addedOrder->branch->company->name}}</h3>
                    </div>
                    <div class="address">
                        Products Order's
                    </div>
                    <div class="mail">
                        <strong>Contact No:</strong> {{ $addedOrder->branch->company->phone ?? ''}}
                    </div>
                </div>                
                <div class="invoice-details">
                    <table class="info-table">
                        <tr>
                            <td class="client-details text-start">
                                <strong>To:</strong>
                                {{$addedOrder->client->user->name ?? ''}}<br>
                                <strong>Address:</strong>
                                @php
                                    $address = optional($addedOrder->clientAddress)->address
                                            ?? optional(optional($addedOrder->client)->user)->location
                                            ?? '';
                                @endphp
                                {{$address ?? ''}}
                            </td>
                            <td class="invoice-info">
                                <strong>Order No:</strong>
                                {{ $addedOrder->order_id ?? ''}}
                                <br>
                                <strong>Order Date:</strong>
                                {{ $addedOrder->order_date ?
    \Carbon\Carbon::parse($addedOrder->order_date)->format('d-m-Y') : '' }}
                            </td>
                        </tr>
                    </table>
                </div>
                <table class="product-table">
                    <thead>
                        <tr>
                            <th class="col-id">S.No</th>
                            <th class="col-description">Description</th>
                            <th class="col-code">HSN Code</th>
                            <th class="col-qty">Qty</th>
                            <th class="col-rate">Rate</th>
                            <th class="col-total">Total</th>
                        </tr>
                    </thead>
                    <tbody>
                        @php
                            $subtotal = 0;
                            $pageSubtotal = 0;
                            $pageCount = 0;               
                        @endphp
                        @foreach ($addedOrder->ordersItem as $index => $product)
                            @php
                                $total = $product->quantity * $product->price;
                                // $gstAmount = ($product->total * $product->quoteItemTaxes->sum('tax')) / 100;
                                // $totalWithGst = $total + $gstAmount;
                                $subtotal += $total;
                                $pageSubtotal += $total;                                                                
                            @endphp
                            <tr>
                                <td class="col-id">{{ $index + 1 }}</td>
                                <td class="col-description">{{ $product->product_name ?? '' }}</td>
                                <td class="col-code">
                                    {{ $product->product->code}}
                                </td>
                                <td class="col-qty">
                                    {{ $product->quantity . '(' . ($product->product->category->unitOfMass->name ?? '') . ')' ?? '' }}
                                </td>
                                <td class="col-rate">₹ {{ number_format($product->price ?? '', 2) }}</td>                               
                                <td class="col-total">@php                                   
                                    $total = $product->total;
                                @endphp
                                    ₹ {{ number_format($total, 2) }}
                                </td>
                            </tr>

                            @if (($index + 1) % 20 == 0)
                                    </tbody>
                                </table>
                                <div class="footer">
                                    <table class="footer-table" style="width: 100%; border-collapse: collapse;">
                                        <tr class="text-start">
                                            <td style="text-align: left;"><strong>Subtotal:</strong> </td>
                                            <td style="text-align: right;">₹ {{ number_format($pageSubtotal, 2) }}</td>
                                        </tr>
                                        <tr class="text-start">
                                            <td style="text-align: left;"><strong>Previous Page Subtotal:</strong></td>
                                            <td style="text-align: right;">
                                                ₹ {{ number_format($subtotal - $pageSubtotal, 2) }}
                                            </td>
                                        </tr>
                                        <tr class="text-start">
                                            <td style="text-align: left;"><strong>Total:</strong></td>
                                            <td style="text-align: right;">₹ {{ number_format($subtotal, 2) }}</td>
                                        </tr>
                                    </table>
                                </div>
                                <p style="text-align: right; margin-bottom: 30px;">...Continue</p>
                                <div class="page-break"></div>
                                <div class="header">
                                    <div class="company-details">
                                        <h3>{{$addedOrder->branch->company->name}}</h3>
                                    </div>
                                    <div class="address">
                                        Products Order's
                                    </div>
                                    <div class="mail">
                                        <strong>Contact No:</strong> {{ $addedOrder->branch->company->phone ?? ''}}
                                    </div>
                                </div>
                                
                                <div class="invoice-details">
                                    <table class="info-table">
                                        <tr>
                                           <td class="client-details text-start">
                                                <strong>To:</strong>
                                                {{$addedOrder->client->user->name ?? ''}}<br>
                                                <strong>Address:</strong>
                                                   {{$address ?? ''}}
                                            </td>
                                            <td class="invoice-info">
                                                <strong>Order No:</strong>
                                                {{ $addedOrder->order_id ?? ''}}
                                                <br>
                                                <strong>Order Date:</strong>
                                                {{ $addedOrder->order_date ?
                    \Carbon\Carbon::parse($addedOrder->order_date)->format('d-m-Y') : '' }}
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                                <table class="product-table">
                                    <thead>
                                        <tr>
                                            <th class="col-id">S.No</th>
                                            <th class="col-description">Description</th>
                                            <th class="col-code">HSN Code</th>
                                            <th class="col-qty">Qty</th>
                                            <th class="col-rate">Rate</th>                                            
                                            <th class="col-total">Total</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @php
                                            $pageSubtotal = 0;
                                            $pageCount++;
                                        @endphp
                            @endif
                        @endforeach </tbody>
                </table>
                <div class="footer">
                    <table class="footer-table" style="width: 100%; border-collapse: collapse;">
                        <tr>
                            <td style="text-align:left"> <strong>Subtotal:</strong></td>
                            <td style="text-align:right;">₹ {{ number_format($pageSubtotal, 2) }}</td>
                        </tr>
                        <tr>
                            <td style="text-align:left"> <strong>Previous Page Subtotal:</strong></td>
                            <td style="text-align:right;">
                                ₹ {{ number_format($subtotal - $pageSubtotal, 2) }}
                            </td>
                        </tr>
                        <tr>
                            <td style="text-align:left"> <strong>Total:</strong></td>
                            <td style="text-align:right;">₹ {{ number_format($subtotal, 2) }}</td>
                        </tr>
                    </table>
                </div>
            </div>

        </div>
    </div>

</body>

</html>