@extends('layouts.layoutapp')

@section('content')
    <div class="main-content">
        <div class="row">
            <div class="col-12">
                <div class="card mb-4 mx-4">
                    <form action="{{ route('branch-store') }}" method="POST" enctype="multipart/form-data">
                        <div class="card-header pb-0">
                            <div class="d-flex flex-row justify-content-between">
                                <div>
                                    <h5 class="mb-0">Add New Branch</h5>
                                </div>

                            </div>
                        </div>

                        <div class="card-body">
                            @csrf
                            <div class="row">
                                <!-- First Column: Company, Prefix, Contact Number, Email -->
                                <div class="col-lg-4">
                                    <div class="col-lg-12 mb-3">
                                        <label for="company" class="form-label">Company:</label>
                                        <select name="company" id="company" class="form-select">
                                            <option value="">Select Company</option>
                                            @foreach($companies as $company)
                                                <option value="{{ $company->id }}" {{ old('company') == $company->id ? 'selected' : '' }}>
                                                    {{ $company->name }}
                                                </option>
                                            @endforeach
                                        </select>
                                        @error('company')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>

                                    <div class="col-lg-12 mb-3">
                                        <label for="prefix" class="form-label">Prefix:</label>
                                        <input type="text" name="prefix" class="form-control" value="{{ old('prefix') }}"
                                            required>
                                        @error('prefix')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>                                    
                                    <div class="col-lg-12 mb-3">
                                        <label for="email" class="form-label">Email:</label>
                                        <input type="email" name="email" class="form-control" value="{{ old('email') }}">
                                        @error('email')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    
                                    <div class="col-lg-12 mb-3">
                                        <label for="loyalty_amount" class="form-label">Loyalty Amount</label>
                                        <input type="number" name="loyalty_amount" id="loyalty_amount" class="form-control"
                                            value=" {{ old('loyalty_amount')}}">
                                        @error('loyalty_amount')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="col-lg-12 mb-3">
                                        <label for="whatsapp_templete" class="form-label">WhatsApp Template </label>
                                        <input type="text" name="whatsapp_template" class="form-control"
                                            value="{{ old('whatsapp_template') }}" >
                                        @error('whatsapp_template')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>

                                <!-- Second Column: Address, Default User, Paper Size -->
                                <div class="col-lg-4">
                                    <div class="col-lg-12 mb-3">
                                        <label for="name" class="form-label">Branch Name:</label>
                                        <input type="text" name="name" class="form-control" value="{{ old('name') }}"
                                            required>
                                        @error('name')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="col-lg-12 mb-3">
                                        <label for="non_gst_prefix" class="form-label">Non-GST Prefix:</label>
                                        <input type="text" name="non_gst_prefix" id="non_gst_prefix" class="form-control"
                                            value="{{ old('non_gst_prefix') }}" required>
                                        @error('non_gst_prefix')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>                                    
                                    <div class="col-lg-12 mb-3">
                                        <label for="address" class="form-label">Address:</label>
                                        <input type="text" name="address" class="form-control" value="{{ old('address') }}">
                                        @error('address')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    
                                    <div class="col-lg-12 mb-3">
                                        <label for="point_redemption" class="form-label">Loyalty Point Value</label>
                                        <input type="number" name="point_redemption" id="point_redemption"
                                            class="form-control" value=" {{ old('point_redemption')}}">
                                        @error('point_redemption')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>

                                </div>

                                <!-- Third Column: Branch Name, GST No, Send Invoice, Logo -->
                                <div class="col-lg-4">
                                    <div class="col-lg-12 mb-3">
                                        <label for="gst_no" class="form-label">GST No:</label>
                                        <input type="text" name="gst_no" class="form-control" value="{{ old('gst_no') }}"
                                            required>
                                        @error('gst_no')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="col-lg-12 mb-3">
                                        <label for="contact_number" class="form-label">Contact Number:</label>
                                        <input type="text" name="contact_number" class="form-control"
                                            value="{{ old('contact_number') }}">
                                        @error('contact_number')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                   <div class="col-lg-12 mb-3">
                                        <label for="user_id" class="form-label">Default User:</label>
                                        <select name="user_id" id="user_id" class="form-select">
                                            <option value="">Select User</option>
                                            @foreach($users as $user)
                                                <option value="{{ $user->id }}" {{ old('user_id') == $user->id ? 'selected' : '' }}>{{ $user->name }}</option>
                                            @endforeach
                                        </select>
                                        @error('user_id')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>

                                    <div class="col-lg-12 mb-3">
                                        <label for="paper_size" class="form-label">Standard Paper:</label>
                                        <select name="paper_size" id="paper_size" class="form-select">
                                            <option value="">Select Standard</option>
                                            @foreach($paperSize as $size)
                                                <option value="{{ $size->id }}" {{ old('paper_size') == $size->id ? 'selected' : '' }}>{{ $size->name }}</option>
                                            @endforeach
                                        </select>
                                        @error('paper_size')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12 mb-3 table-responsive d-flex justify-content-center">
                                <table class="table table-bordered text-xs w-auto">
                                    <thead>
                                        <tr>
                                            <th>Send Invoice</th>
                                            <th>Loyalty Point</th>
                                            <th>Note</th>
                                            <th>Term</th>
                                            <th>Description</th>
                                            <th>Tax</th>
                                            <th>Signature</th>
                                            <th>Available Qty Validate</th>
                                            <th>Native Name</th>
                                            <th>Is Header</th>
                                            <th>Non Gst</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td class="text-center">
                                                <input type="checkbox" name="send_invoice" id="send_invoice"
                                                    style="width: 18px; height: 18px;" value="1" {{ old('send_invoice') ? 'checked' : '' }}>
                                                @error('send_invoice')<span
                                                class="text-danger">{{ $message }}</span>@enderror
                                            </td>
                                            <td style="padding: 10px; text-align: center;">
                                                <input type="checkbox" name="loyalty_point" id="loyalty_point"
                                                    style="width: 18px; height: 18px;" value="1" {{ old('loyalty_point') ? 'checked' : '' }}>
                                                @error('loyalty_point')<span
                                                class="text-danger">{{ $message }}</span>@enderror
                                            </td>
                                            <td style="padding: 10px; text-align: center;">
                                                <input type="checkbox" name="note" id="note"
                                                    style="width: 18px; height: 18px;" value="1" {{ old('note') ? 'checked' : '' }}>
                                                @error('note')<span class="text-danger">{{ $message }}</span>@enderror
                                            </td>
                                            <td style="padding: 10px; text-align: center;">
                                                <input type="checkbox" name="term" id="term"
                                                    style="width: 18px; height: 18px;" value="1" {{ old('term') ? 'checked' : '' }}>
                                                @error('term')<span class="text-danger">{{ $message }}</span>@enderror
                                            </td>
                                            <td style="padding: 10px; text-align: center;">
                                                <input type="checkbox" name="description" id="description"
                                                    style="width: 18px; height: 18px;" value="1" {{ old('description') ? 'checked' : '' }}>
                                                @error('description')<span
                                                class="text-danger">{{ $message }}</span>@enderror
                                            </td>
                                            <td style="padding: 10px; text-align: center;">
                                                <input type="checkbox" name="price_tax" id="price_tax"
                                                    style="width: 18px; height: 18px;" value="1" {{ old('price_tax') == 'A' ? 'checked' : '' }}>
                                                @error('price_tax')<span class="text-danger">{{ $message }}</span>@enderror
                                            </td>
                                            <td style="padding: 10px; text-align: center;">
                                                <input type="checkbox" name="signature" id="signature"
                                                    style="width: 18px; height: 18px;" value="1" {{ old('signature') == 'A' ? 'checked' : '' }}>
                                                @error('signature')<span class="text-danger">{{ $message }}</span>@enderror
                                            </td>
                                            <td style="padding: 10px; text-align: center;">
                                                <input type="checkbox" name="avl_qty" id="avl_qty"
                                                    style="width: 18px; height: 18px;" value="1" {{ old('avl_qty') == 'A' ? 'checked' : '' }}>
                                                @error('avl_qty')<span class="text-danger">{{ $message }}</span>@enderror
                                            </td>
                                            <td style="padding: 10px; text-align: center;">
                                                <input type="checkbox" name="native_name" id="native_name"
                                                    style="width: 18px; height: 18px;" value="1" {{ old('avl_qty') == 'A' ? 'checked' : '' }}>
                                                @error('avl_qty')<span class="text-danger">{{ $message }}</span>@enderror
                                            </td>
                                            <td style="padding: 10px; text-align: center;">
                                                <input type="checkbox" name="is_header" id="is_header"
                                                    style="width: 18px; height: 18px;" value="1" {{ old('is_header') == 'A' ? 'checked' : '' }}>
                                                @error('is_header')<span class="text-danger">{{ $message }}</span>@enderror
                                            </td>
                                            <td style="padding: 10px; text-align: center;">
                                                <input type="checkbox" name="non_gst" id="non_gst"
                                                    style="width: 18px; height: 18px;" value="1" {{ old('non_gst') == 'A' ? 'checked' : '' }}>
                                                @error('non_gst')<span class="text-danger">{{ $message }}</span>@enderror
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            <div class="col-lg-12 mb-3">
                                <label for="declaration" class="form-label">Terms & Condition</label>
                                <textarea name="declaration" class="form-control"
                                    rows="2"> {{ old('declaration') }}</textarea>
                                @error('declaration')
                                    <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="col-lg-12 mb-3">
                                <label for="logo" class="form-label">Logo:</label>
                                <div class="d-flex align-items-center mt-2">
                                    <div class="avatar-upload me-5">
                                        <div class="avatar-preview">
                                            <img id="logoPreview" src="{{ asset('assets/img/logos/Product.png') }}"
                                                alt="Default Image" class="img-fluid mt-4"
                                                style="height: 80px; width: auto; max-width:250px;">
                                        </div>
                                    </div>
                                    <div class="avatar-edit">
                                        <input type="file" id="logo" class="form-control file-upload-input" accept="image/*"
                                            name="logo" onchange="previewLogo(this)">
                                        <small class="text-muted d-block mt-1">Recommended size:
                                            <strong>781x320</strong> pixels</small>
                                    </div>
                                </div>
                                @error('logo')
                                    <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>


                            <div class="card-footer">
                                <button type="submit" class="btn btn-primary ms-0">Save Branch</button>
                                <a href="{{ route('branch-index') }}" class="btn btn-secondary">Cancel</a>
                            </div>
                        </div>

                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        function previewLogo(input) {
            const preview = document.getElementById('logoPreview');
            const file = input.files[0];
            const reader = new FileReader();

            reader.onloadend = function () {
                preview.src = reader.result;
            }

            if (file) {
                reader.readAsDataURL(file);
            } else {
                preview.src = "{{ asset('assets/img/logos/Product.png') }}";
            }
        }
    </script>
@endpush