<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <!-- Metas -->
    @if (env('IS_DEMO'))
        <x-demo-metas></x-demo-metas>
    @endif
    <link rel="apple-touch-icon" sizes="76x76" href="../assets/img/apple-icon.png">
    <link rel="icon" type="image/png" href="../assets/img/favicon3.png">
    <title>Billing - Client Registration</title>

    <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,400,600,700" rel="stylesheet" />

    <link href="../assets/css/bootstrap.min.css" rel="stylesheet" />
    <link href="../assets/css/nucleo-icons.css" rel="stylesheet" />
    <link href="../assets/css/nucleo-svg.css" rel="stylesheet" />
    <link href="../assets/css/style.css" rel="stylesheet" />
    <link id="pagestyle" href="../assets/css/soft-ui-dashboard.css?v=1" rel="stylesheet" />

</head>

<body class="mt-5" style="background-color: rgb(217, 236, 255)">
    <div class="container-fluid py-4">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h5 class="card-title">Client Registration</h5>
                    </div>
                    <div class="card-body">
                        <form id="clientForm" action="{{ route('registration-form-save') }}" method="POST"
                            enctype="multipart/form-data">
                            @csrf
                            <div class="row">
                                <div class="col-lg-6 row">
                                    <div class="col-lg-6 mb-3">
                                        <label for="first_name" class="form-label">First Name: <span
                                                class="text-danger">*</span></label>
                                        <input type="text" id="first_name" name="first_name" class="form-control"
                                            value="{{ old('first_name') }}" placeholder="Enter first name">
                                        @error('first_name') <span class="text-danger">{{ $message }}</span> @enderror
                                    </div>
                                    <div class="col-lg-6 mb-3">
                                        <label for="last_name" class="form-label">Last Name:</label>
                                        <input type="text" id="last_name" name="last_name" class="form-control"
                                            value="{{ old('last_name') }}" placeholder="Enter last name">
                                        @error('last_name') <span class="text-danger">{{ $message }}</span> @enderror
                                    </div>
                                    <div class="col-lg-6 mb-3">
                                        <label for="email" class="form-label">Email: <span
                                                class="text-danger">*</span></label>
                                        <input type="email" id="email" name="email" class="form-control"
                                            value="{{ old('email') }}" placeholder="Enter email address">
                                        @error('email') <span class="text-danger">{{ $message }}</span> @enderror
                                    </div>
                                    <div class="col-lg-6 mb-3">
                                        <label for="contact_no" class="form-label">Contact No: <span
                                                class="text-danger">*</span></label>
                                        <input type="tel" id="contact_no" name="contact_no" class="form-control"
                                            value="{{ old('contact_no') }}" placeholder="Enter contact number"
                                            pattern="[0-9]{10,15}">
                                        @error('contact_no') <span class="text-danger">{{ $message }}</span> @enderror
                                    </div>
                                    <div class="col-lg-6 mb-3">
                                        <label for="password" class="form-label">Password: <span
                                                class="text-danger">*</span></label>
                                        <div class="input-group">
                                            <input type="password" id="password" name="password" class="form-control"
                                                placeholder="Enter password" minlength="6">
                                        </div>
                                        @error('password') <span class="text-danger">{{ $message }}</span> @enderror
                                    </div>
                                    <div class="col-lg-6 mb-3">
                                        <label for="password_confirmation" class="form-label">Confirm Password: <span
                                                class="text-danger">*</span></label>
                                        <div class="input-group">
                                            <input type="password" id="password_confirmation"
                                                name="password_confirmation" class="form-control"
                                                placeholder="Confirm password">
                                            </button>
                                        </div>
                                        @error('password_confirmation') <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="col-lg-6 mb-3">
                                        <label for="address" class="form-label">Address: <span
                                                class="text-danger">*</span></label>
                                        <input type="text" id="address" name="address" class="form-control"
                                            value="{{ old('address') }}" placeholder="Enter address">
                                        @error('address') <span class="text-danger">{{ $message }}</span> @enderror
                                    </div>
                                    <div class="col-lg-6 mb-3">
                                        <label for="postal_code" class="form-label">Postal Code: <span
                                                class="text-danger">*</span></label>
                                        <input type="text" id="postal_code" name="postal_code" class="form-control"
                                            value="{{ old('postal_code') }}" placeholder="Enter postal code">
                                        @error('postal_code') <span class="text-danger">{{ $message }}</span> @enderror
                                    </div>
                                </div>
                                <div class="col-lg-6 row">
                                    <div class="col-12 mb-3">
                                        <label for="profile_image" class="form-label">Profile Image:</label>
                                        <div class="d-flex align-items-center">
                                            <div class="avatar-upload me-5">
                                                <div class="avatar-preview">
                                                    <img id="profilePreview"
                                                        src="{{ old('profile_image') ? asset('storage/' . old('profile_image')) : asset('assets/img/logos/profile.png') }}"
                                                        alt="Profile Image" class="img-fluid rounded-circle"
                                                        style="height:125px; width:125px; object-fit: cover;">
                                                </div>
                                            </div>
                                            <div class="avatar-edit">
                                                <input type="file" id="profile_image" name="profile_image"
                                                    class="form-control file-upload-input" accept="image/*"
                                                    onchange="previewImage(this)">
                                                <small class="text-muted d-block">Max 2MB (JPEG, PNG, JPG)</small>
                                            </div>
                                        </div>
                                        @error('profile_image') <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>

                                    <div class="col-lg-6 mb-3">
                                        <label for="branch" class="form-label">Branch: <span
                                                class="text-danger">*</span></label>
                                        <select name="branch_id" id="branch_id" class="form-select">
                                            <option value="">Select Branch</option>
                                            @foreach ($branch as $item)
                                                <option value="{{$item->id}}" {{old('branch_id') == $item->id ? 'selected' : ''}}>{{$item->name}}</option>
                                            @endforeach
                                        </select>
                                        @error('branch_id') <span class="text-danger">{{ $message }}</span> @enderror
                                    </div>

                                    <div class="col-lg-6 mb-3">
                                        <label for="notes" class="form-label">Notes:</label>
                                        <textarea id="notes" name="notes" class="form-control"
                                            placeholder="Enter any notes" rows="1">{{ old('notes') }}</textarea>
                                        @error('notes') <span class="text-danger">{{ $message }}</span> @enderror
                                    </div>
                                    <div class="col-lg-6 mb-3">
                                        <label for="gstin" class="form-label">GSTIN:</label>
                                        <input type="text" id="gstin" name="gstin" class="form-control"
                                            value="{{ old('gstin') }}" placeholder="Enter GSTIN number"
                                            pattern="^[0-9]{2}[A-Z]{5}[0-9]{4}[A-Z]{1}[1-9A-Z]{1}Z[0-9A-Z]{1}$">
                                        @error('gstin') <span class="text-danger">{{ $message }}</span> @enderror
                                    </div>
                                    <div class="col-lg-6 mb-3">
                                        <label for="active_status" class="form-label">Active Status:</label>
                                        <select id="active_status" name="active_status" class="form-select">
                                            <option value="A" {{ old('active_status', 'A') == 'A' ? 'selected' : '' }}>
                                                Active
                                            </option>
                                            <option value="I" {{ old('active_status') == 'I' ? 'selected' : '' }}>Inactive
                                            </option>
                                        </select>
                                        @error('active_status') <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                            <div class="row mt-3">
                                <div class="col-12 text-end">
                                    <button type="submit" class="btn btn-primary">Save Client</button>
                                    <a href="{{ route('client-index') }}" class="btn btn-secondary">Cancel</a>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <script>
        $(document).ready(function () {

            $('.toggle-password').click(function () {
                const input = $(this).siblings('input');
                const icon = $(this).find('i');
                const type = input.attr('type') === 'password' ? 'text' : 'password';
                input.attr('type', type);
                icon.toggleClass('fa-eye fa-eye-slash');
            });

            @if (session('success'))
                Swal.fire({
                    icon: 'success',
                    title: 'Success!',
                    text: '{{ session('success') }}',
                    confirmButtonColor: '#3085d6',
                    confirmButtonText: 'OK'
                });
            @endif

            @if (session('error'))
                Swal.fire({
                    icon: 'error',
                    title: 'Error!',
                    text: '{{ session('error') }}',
                    confirmButtonColor: '#d33',
                    confirmButtonText: 'OK'
                });
            @endif
            
        });

        function previewImage(input) {
            if (input.files && input.files[0]) {
               
                if (input.files[0].size > 2 * 1024 * 1024) {
                    Swal.fire({
                        icon: 'error',
                        title: 'File too large',
                        text: 'Please select an image smaller than 2MB',
                        confirmButtonColor: '#d33',
                        confirmButtonText: 'OK'
                    });
                    input.value = '';
                    return;
                }

                const validTypes = ['image/jpeg', 'image/png', 'image/jpg'];
                if (!validTypes.includes(input.files[0].type)) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Invalid file type',
                        text: 'Please upload a JPEG, PNG, or JPG image',
                        confirmButtonColor: '#d33',
                        confirmButtonText: 'OK'
                    });
                    input.value = '';
                    return;
                }

                const reader = new FileReader();
                reader.onload = function (e) {
                    document.getElementById('profilePreview').src = e.target.result;
                }
                reader.readAsDataURL(input.files[0]);
            }
        }
    </script>
</body>

</html>