<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CategoryModel extends Model
{
    use HasFactory;

    protected $table = 'categories';

    protected $primaryKey = 'id';

    public $timestamps = true;


    protected $fillable = [
        'name',
        'uom',
        'branch_id'
    ];
    public function unitOfMass()
    {
        return $this->belongsTo(UomModel::class, 'uom');
    }
}
