<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Facades\Auth;

class CheckCompanyAndBranchSetup
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $user = Auth::user();

        if ($user->companies()->count() == 0 || $user->branches()->count() == 0) {
            return redirect()->route('setup');
        }

        if (!session('comp_id') || !session('branch_id')) {
            return redirect()->route('setup');
        }

        return $next($request);
    }
}
