<?php

namespace App\Http\Controllers;

use App\Imports\CategoriesImport;
use App\Imports\ClientImport;
use App\Imports\ProductImport;
use App\Imports\SupplierImport;
use App\Imports\TaxImport;
use Illuminate\Http\Request;
use Maatwebsite\Excel\Facades\Excel;

class ImportController extends Controller
{

    public function productIndex()
    {
        return view('imports.product-import');
    }
    public function productImport(Request $request)
    {
        $request->validate(['file' => 'required|mimes:xlsx,xls,csv']);
        try {

            storeFile($request->file('file'), 'imports');
            session()->put('pro_err', []);
            Excel::import(new ProductImport(), $request->file('file'));

            $error = session()->get('pro_err', []);
            if ($error) {
                session()->flash('product_import_error', $error);
                return redirect()->route('product-import-index');
            } else {
                return redirect()->route('product-index')->with('success', 'Products Imported Successfully!');
            }
        } catch (\Exception $e) {
            return redirect()->route('product-index')->with('Product Import has been failed, Please try again.');
        }
    }

    public function categoriesIndex()
    {
        return view('imports.categories-import');
    }

    public function categoriesImport(Request $request)
    {
        $request->validate(['file' => 'required|mimes:xlsx,xls,csv']);
        try {

            storeFile($request->file('file'), 'imports');
            session()->put('cat_err', []);
            Excel::import(new CategoriesImport(), $request->file('file'));

            $error = session()->get('cat_err', []);
            if ($error) {
                session()->flash('categories_import_error', $error);
                return redirect()->route('categories-import-index');
            } else {
                return redirect()->route('category-index')->with('success', 'Categories Imported Successfully!');
            }
        } catch (\Exception $e) {
            return redirect()->route('category-index')->with('  Import has been failed, Please try again.');
        }
    }

    public function supplierIndex()
    {
        return view('imports.supplier-import');
    }

    public function supplierImport(Request $request)
    {
        $request->validate(['file' => 'required|mimes:xlsx,xls,csv']);
        try {

            storeFile($request->file('file'), 'imports');
            session()->put('supplier_err', []);
            Excel::import(new SupplierImport(), $request->file('file'));

            $error = session()->get('supplier_err', []);
            // dd($error);
            if ($error) {
                session()->flash('supplier_import_error', $error);
                return redirect()->route('supplier-import-index');
            } else {
                return redirect()->route('supplier-index')->with('success', 'Suppliers Imported Successfully!');
            }
        } catch (\Exception $e) {
            return redirect()->route('supplier-index')->with('Suppliers Import has been failed, Please try again.');
        }
    }

    public function clientIndex()
    {
        return view('imports.client-import');
    }
    public function clientImport(Request $request)
    {
        $request->validate(['file' => 'required|mimes:xlsx,xls,csv']);
        try {

            storeFile($request->file('file'), 'imports');
            session()->put('client_err', []);
            Excel::import(new ClientImport(), $request->file('file'));
            $error = session()->get('client_err', []);
            // dd($error);
            if ($error) {
                session()->flash('client_import_error', $error);
                return redirect()->route('client-import-index');
            } else {
                return redirect()->route('client-index')->with('success', 'Suppliers Imported Successfully!');
            }
        } catch (\Exception $e) {
            return redirect()->route('client-index')->with('Suppliers Import has been failed, Please try again.');
        }
    }
    public function taxIndex()
    {
        return view('imports.tax-import');
    }
    public function taxImport(Request $request)
    {
        $request->validate(['file' => 'required|mimes:xlsx,xls,csv']);
        try {

            storeFile($request->file('file'), 'imports');
            session()->put('tax_err', []);
            Excel::import(new TaxImport(), $request->file('file'));
            $error = session()->get('tax_err', []);
            // dd($error);
            if ($error) {
                session()->flash('tax_import_error', $error);
                return redirect()->route('tax-import-index');
            } else {
                return redirect()->route('tax-index')->with('success', 'Taxes Imported Successfully!');
            }
        } catch (\Exception $e) {
            return redirect()->route('tax-index')->with('Taxes Import has been failed, Please try again.');
        }
    }
}
